/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.utils;

import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.SysConfigModelType;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.bo.ImConfigUpdateContext;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(SysConfigHelper.class);
    @Resource
    private NiccCsmConfigProperties csmConfigProperties;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;

    public void initImSysConfig() {
        Map configMap = NiccCommonUtil.beanToMap((Object)this.csmConfigProperties);
        log.info("\u521d\u59cb\u5316\u7cfb\u7edf\u53c2\u6570-\u5f53\u524d\u914d\u7f6e:{}", (Object)configMap);
        String cacheKey = RedisCacheKeyConstant.getSysConfigKey((String)SysConfigModelType.nicc_csm.getCode());
        Map configs = this.redisHelper.hmget(cacheKey);
        if (configs != null) {
            try {
                this.updateObjProperties(configs, this.csmConfigProperties);
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u53c2\u6570-\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38:{}, type = {},configs = {}", new Object[]{e.getMessage(), SysConfigModelType.nicc_im.getCode(), configs});
            }
        }
    }

    public Map<Object, Object> updateObjProperties(Map<Object, Object> configMap, Object obj) throws Exception {
        HashMap<Object, Object> successUpdateMap = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : configMap.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            Field fieldName = obj.getClass().getDeclaredField(key);
            fieldName.setAccessible(true);
            if (!ObjectUtils.allNotNull((Object[])new Object[]{fieldName, val})) continue;
            log.info("\u8bbe\u7f6e\u7cfb\u7edf\u914d\u7f6e\u53d8\u91cf-\u4fee\u6539\u7cfb\u7edf\u53c2\u6570:{}-{}", (Object)key, val);
            fieldName.set(obj, entry.getValue());
            successUpdateMap.put(key, val);
        }
        return successUpdateMap;
    }

    public Map<String, Object> setSysConfig(String type, Map<Object, Object> configMap) throws Exception {
        return this.setSysConfig(type, configMap, true);
    }

    public Map<String, Object> setSysConfig(String type, Map<Object, Object> configMap, boolean sync) throws Exception {
        log.info("\u8bbe\u7f6e\u7cfb\u7edf\u914d\u7f6e\u53d8\u91cf:{}-{}", (Object)type, configMap);
        Map<Object, Object> successUpdateMap = new HashMap();
        if (!SysConfigModelType.nicc_csm.getCode().equals(type)) {
            throw new RuntimeException("\u7cfb\u7edf\u7c7b\u578b\u9519\u8bef: type = " + type);
        }
        successUpdateMap = this.updateObjProperties(configMap, this.csmConfigProperties);
        if (sync) {
            String cacheKey = RedisCacheKeyConstant.getSysConfigKey((String)type);
            for (Map.Entry<Object, Object> entry : successUpdateMap.entrySet()) {
                String key = entry.getKey().toString();
                Object val = entry.getValue();
                this.redisHelper.hset(cacheKey, key, val);
            }
            ImConfigUpdateContext updateContext = ImConfigUpdateContext.builder().tenantCode("").type(SysConfigModelType.valueOf((String)type)).properties(configMap).build();
            this.kkMqProducerHelper.sendMsg("IM_SYS_CONF_UPDATE", (Object)updateContext);
        }
        return this.getSysConfig(type);
    }

    public Map<String, Object> getSysConfig(String type) {
        HashMap<String, Object> configMap = new HashMap();
        if (SysConfigModelType.nicc_csm.getCode().equals(type)) {
            configMap = NiccCommonUtil.beanToMap((Object)this.csmConfigProperties);
        }
        log.info("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53d8\u91cf:{}-{}", (Object)type, configMap);
        return configMap;
    }
}

