/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.wOrder;

import com.alibaba.excel.EasyExcel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderSuggestionBO;
import com.tydic.nicc.csm.api.wOrder.AdviceApi;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.WOrderSuggestionMapper;
import com.tydic.nicc.csm.mapper.po.UserInfoPO;
import com.tydic.nicc.csm.mapper.po.WOrderSuggestion;
import com.tydic.nicc.csm.utils.excel.WOrderSuggestionExcelDTO;
import com.tydic.nicc.csm.wOrder.NotifyService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AdviceServiceImpl
implements AdviceApi {
    private static final Logger log = LoggerFactory.getLogger(AdviceServiceImpl.class);
    @Resource
    private FileManagerHelper fileManagerHelper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private WOrderSuggestionMapper wOrderSuggestionMapper;
    @Resource
    private NotifyService notifyService;

    public Rsp submit(WOrderSuggestionBO request) {
        log.info("\u63d0\u4ea4\u610f\u89c1\u53cd\u9988:{}", (Object)request);
        WOrderSuggestion po = new WOrderSuggestion();
        if (ObjectUtils.isEmpty((Object)request.getSuggestId())) {
            BeanUtils.copyProperties((Object)request, (Object)po);
            po.setSuggestId(Integer.valueOf((int)IdWorker.nextAutoId()));
            po.setCreateTime(new Date());
            UserInfoPO userInfo = this.wOrderSuggestionMapper.getUserInfo(request.getUserId());
            if (ObjectUtils.isNotEmpty((Object)userInfo)) {
                po.setUsername(userInfo.getUserName());
                po.setTenantName(userInfo.getCompName());
            }
            this.wOrderSuggestionMapper.insertSelective(po);
        } else {
            po.setSuggestId(request.getSuggestId());
            po.setRpContent(request.getRpContent());
            po.setRpTime(new Date());
            po.setRpAttachment(request.getRpAttachment());
            po.setStatus(EntityValidType.NORMAL.getCode());
            this.wOrderSuggestionMapper.update(po);
            WOrderSuggestion suggestion = this.wOrderSuggestionMapper.queryById(request.getSuggestId());
            try {
                this.notifyService.sendMessageShop(String.valueOf(request.getSuggestId()), request.getUserId(), "1", suggestion.getUserId());
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u5546\u57ce\u63a5\u53e3\u901a\u77e5\u5931\u8d25:", (Throwable)e);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)po.getSuggestId());
    }

    public RspList query(WOrderSuggestionBO request) {
        log.info("\u610f\u89c1\u53cd\u9988\u5217\u8868\uff1a{}", (Object)request);
        WOrderSuggestion cond = new WOrderSuggestion();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setTenantCode(null);
        cond.setUserId(null);
        Page suggestions = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.wOrderSuggestionMapper.selectAll(cond);
        return BaseRspUtils.createSuccessRspList((List)suggestions.getResult(), (long)suggestions.getTotal());
    }

    public Rsp export(WOrderSuggestionBO request) {
        List bos;
        WOrderSuggestion cond = new WOrderSuggestion();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setTenantCode(null);
        cond.setUserId(null);
        List suggestions = this.wOrderSuggestionMapper.selectAll(cond);
        ArrayList writeList = new ArrayList();
        NiccCommonUtil.copyList((List)suggestions, writeList, WOrderSuggestionExcelDTO.class);
        Iterator iterator = writeList.iterator();
        while (iterator.hasNext()) {
            WOrderSuggestionExcelDTO dto;
            dto.setStatus((dto = (WOrderSuggestionExcelDTO)iterator.next()).getStatus().equals("0") ? "\u672a\u53cd\u9988" : "\u5df2\u53cd\u9988");
        }
        File file = this.newTmpFile();
        EasyExcel.write((File)file, WOrderSuggestionExcelDTO.class).sheet("\u610f\u89c1\u53cd\u9988").doWrite(writeList);
        try {
            bos = this.fileManagerHelper.saveFile(file, this.nowMonth());
            if (CollectionUtils.isEmpty((Collection)bos)) {
                return BaseRspUtils.createSuccessRsp((Object)"\u5bfc\u51fa\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            return BaseRspUtils.createSuccessRsp((Object)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        return BaseRspUtils.createSuccessRsp(bos.get(0));
    }

    public Rsp info(WOrderSuggestionBO request) {
        log.info("\u610f\u89c1\u53cd\u9988\u8be6\u60c5\uff1a{}", (Object)request);
        WOrderSuggestion suggestion = this.wOrderSuggestionMapper.queryById(request.getSuggestId());
        return BaseRspUtils.createSuccessRsp((Object)suggestion);
    }

    public String nowMonth() {
        return DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMM");
    }

    public File newTmpFile() {
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + System.currentTimeMillis() + ".xlsx";
        log.info("\u65b0\u5efa\u4e34\u65f6\u6587\u4ef6:{}", (Object)filePath);
        return new File(filePath);
    }
}

