/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.wOrder;

import com.alibaba.excel.EasyExcel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderBO;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderMessageBO;
import com.tydic.nicc.csm.api.wOrder.OrderApi;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsInfoSkillRelMapper;
import com.tydic.nicc.csm.mapper.WOrderMapper;
import com.tydic.nicc.csm.mapper.WOrderMessageMapper;
import com.tydic.nicc.csm.mapper.WOrderSuggestionMapper;
import com.tydic.nicc.csm.mapper.WOrderTypeMapper;
import com.tydic.nicc.csm.mapper.po.UserInfoPO;
import com.tydic.nicc.csm.mapper.po.WOrder;
import com.tydic.nicc.csm.mapper.po.WOrderMessage;
import com.tydic.nicc.csm.mapper.po.WOrderType;
import com.tydic.nicc.csm.utils.excel.WOrderDTO;
import com.tydic.nicc.csm.wOrder.NotifyService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderApi {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private WOrderMapper wOrderMapper;
    @Resource
    WOrderTypeMapper wOrderTypeMapper;
    @Resource
    private CsInfoSkillRelMapper csInfoSkillRelMapper;
    @Resource
    private WOrderSuggestionMapper wOrderSuggestionMapper;
    @Resource
    private WOrderMessageMapper wOrderMessageMapper;
    @Resource
    private NotifyService notifyService;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private FileManagerHelper fileManagerHelper;

    public Rsp submit(WOrderBO request) {
        UserInfoPO userInfo;
        WOrder po = new WOrder();
        BeanUtils.copyProperties((Object)request, (Object)po);
        this.buildNameInfo(request, po);
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderUserId()) && ObjectUtils.isNotEmpty((Object)(userInfo = this.wOrderSuggestionMapper.getUserInfo(request.getOrderUserId())))) {
            po.setOrderTenantName(userInfo.getCompName());
        }
        if (StringUtils.isEmpty((CharSequence)request.getOrderId())) {
            String createUserName = this.wOrderSuggestionMapper.getUserName(request.getUserId());
            po.setCreateUserName(createUserName);
            po.setOrderId(IdWorker.nextAutoIdStr());
            po.setCreateTenantCode(request.getTenantCode());
            po.setCreateUserId(request.getUserId());
            po.setUpdateTime(new Date());
            this.wOrderMapper.insertSelective(po);
        } else {
            po.setHandleUser(request.getUserId());
            po.setHandleTime(new Date());
            po.setUpdateTime(new Date());
            this.wOrderMapper.update(po);
            if (StringUtils.isNotEmpty((CharSequence)request.getOrderStatus()) && !request.getOrderStatus().equals(OrderApi.ORDER_STATUS.CLOSE.getCode())) {
                this.saveMessage(request);
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getMsgType()) && request.getMsgType().equals("1")) {
                this.saveMessage(request);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)po.getOrderId());
    }

    public Rsp info(WOrderBO request) {
        log.info("\u5de5\u5355\u8be6\u60c5\u67e5\u8be2:{}", (Object)request);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{request.getOrderUserId(), request.getHandleTenant()})) {
            return BaseRspUtils.createErrorRsp((String)"\u5173\u8054\u7528\u6237id\u548c\u5de5\u5355\u53d7\u7406\u673a\u6784\u4e0d\u5f97\u4e3a\u7a7a");
        }
        List skillGids = this.csInfoSkillRelMapper.selectSkillGids(request.getTenantCode(), request.getUserId());
        if (CollectionUtils.isEmpty((Collection)skillGids)) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        WOrder wOrder = this.wOrderMapper.queryByCond(request.getOrderUserId(), request.getHandleTenant(), skillGids);
        if (ObjectUtils.isEmpty((Object)wOrder)) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        WOrderBO rsp = new WOrderBO();
        BeanUtils.copyProperties((Object)wOrder, (Object)rsp);
        WOrderType orderType = this.wOrderTypeMapper.queryById(rsp.getOrderTypeId());
        if (orderType.getLevel() == 0) {
            rsp.setLevel1TypeName(orderType.getName());
        }
        if (orderType.getLevel() == 1) {
            WOrderType parentType = this.wOrderTypeMapper.queryById(orderType.getParentId());
            rsp.setLevel1TypeName(parentType.getName());
            rsp.setLevel2TypeName(orderType.getName());
        }
        String userName = this.wOrderSuggestionMapper.getUserName(wOrder.getCreateUserId());
        rsp.setCreateUserName(userName);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public Rsp getLastMsg(WOrderBO request) {
        WOrderMessage orderMessage = this.wOrderMessageMapper.queryLastMsg(request.getOrderId());
        return BaseRspUtils.createSuccessRsp((Object)orderMessage);
    }

    public RspList msgList(WOrderBO request) {
        WOrderMessage cond = new WOrderMessage();
        cond.setOrderId(request.getOrderId());
        List messages = this.wOrderMessageMapper.selectAll(cond);
        if (!request.getTenantCode().equals("platform")) {
            messages = messages.stream().filter(v -> v.getMsgType().equals("0")).collect(Collectors.toList());
        }
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList(messages, res, WOrderMessageBO.class);
        for (WOrderMessageBO re : res) {
            String userName = this.wOrderSuggestionMapper.getUserName(re.getSendUser());
            re.setSendUserName(userName);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList orderList(WOrderBO request) {
        WOrder cond = new WOrder();
        if (!request.getTenantCode().equals("platform")) {
            if (StringUtils.isEmpty((CharSequence)request.getHandleSkill())) {
                List skillGids = this.csInfoSkillRelMapper.selectSkillGids(request.getTenantCode(), request.getUserId());
                request.setHandleSkillList(skillGids);
            }
            if (StringUtils.isEmpty((CharSequence)request.getHandleTenant())) {
                request.setHandleTenant(request.getTenantCode());
            }
        }
        BeanUtils.copyProperties((Object)request, (Object)cond);
        Page orders = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.wOrderMapper.selectAll(cond);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)orders, res, WOrderBO.class);
        for (WOrderBO re : res) {
            re.setOrderStatusName(OrderApi.ORDER_STATUS.getNameByCode((String)re.getOrderStatus()));
        }
        return BaseRspUtils.createSuccessRspList(res, (long)orders.getTotal());
    }

    public Rsp notify(WOrderBO request) {
        log.info("\u5de5\u5355\u901a\u77e5:{}", (Object)request);
        String orderId = request.getOrderId();
        WOrder wOrder = this.wOrderMapper.queryById(orderId);
        try {
            this.notifyService.sendMessageShop(orderId, request.getUserId(), "2", wOrder.getOrderUserId());
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u5de5\u5355\u901a\u77e5\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u5de5\u5355\u901a\u77e5\u6210\u529f");
    }

    public Rsp export(WOrderBO request) {
        List bos;
        WOrder cond = new WOrder();
        if (!request.getTenantCode().equals("platform")) {
            if (StringUtils.isEmpty((CharSequence)request.getHandleSkill())) {
                List skillGids = this.csInfoSkillRelMapper.selectSkillGids(request.getTenantCode(), request.getUserId());
                request.setHandleSkillList(skillGids);
            }
            if (StringUtils.isEmpty((CharSequence)request.getHandleTenant())) {
                request.setHandleTenant(request.getTenantCode());
            }
        }
        BeanUtils.copyProperties((Object)request, (Object)cond);
        List wOrders = this.wOrderMapper.selectAll(cond);
        ArrayList writeList = new ArrayList();
        NiccCommonUtil.copyList((List)wOrders, writeList, WOrderDTO.class);
        for (WOrderDTO re : writeList) {
            re.setOrderStatusName(OrderApi.ORDER_STATUS.getNameByCode((String)re.getOrderStatus()));
        }
        File file = this.newTmpFile();
        EasyExcel.write((File)file, WOrderDTO.class).sheet("\u5de5\u5355\u62a5\u8868").doWrite(writeList);
        try {
            bos = this.fileManagerHelper.saveFile(file, this.nowMonth());
            if (CollectionUtils.isEmpty((Collection)bos)) {
                return BaseRspUtils.createSuccessRsp((Object)"\u5bfc\u51fa\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            return BaseRspUtils.createSuccessRsp((Object)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        return BaseRspUtils.createSuccessRsp(bos.get(0));
    }

    public String nowMonth() {
        return DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMM");
    }

    public File newTmpFile() {
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + System.currentTimeMillis() + ".xlsx";
        log.info("\u65b0\u5efa\u4e34\u65f6\u6587\u4ef6:{}", (Object)filePath);
        return new File(filePath);
    }

    public void buildNameInfo(WOrderBO request, WOrder po) {
        String orderUserName = this.wOrderSuggestionMapper.getUserName(request.getOrderUserId());
        po.setOrderUserName(orderUserName);
        String handleTenantName = this.wOrderSuggestionMapper.getTenantName(request.getHandleTenant());
        po.setHandleTenantName(handleTenantName);
        String handleSkillName = this.wOrderSuggestionMapper.getSkillName(request.getHandleSkill());
        po.setHandleSkillName(handleSkillName);
    }

    public void saveMessage(WOrderBO request) {
        WOrderMessage message = new WOrderMessage();
        BeanUtils.copyProperties((Object)request, (Object)message);
        message.setMessageId(IdWorker.nextAutoIdStr());
        message.setAttachment(request.getMsgAttachment());
        message.setContent(request.getHandleResult());
        message.setSendUser(request.getUserId());
        message.setMsgTime(new Date());
        if (request.getTenantCode().equals("platform")) {
            message.setUserType("1");
        } else {
            message.setUserType("0");
        }
        this.wOrderMessageMapper.insertSelective(message);
    }
}

