/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.wOrder;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderFieldBO;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderSaveReqBO;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderTypeEntity;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderTypeReqBO;
import com.tydic.nicc.csm.api.bo.wOrder.WOrderTypeRspBO;
import com.tydic.nicc.csm.api.wOrder.OrderTypeApi;
import com.tydic.nicc.csm.mapper.WOrderFieldMapper;
import com.tydic.nicc.csm.mapper.WOrderTypeMapper;
import com.tydic.nicc.csm.mapper.po.WOrderField;
import com.tydic.nicc.csm.mapper.po.WOrderType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderTypeServiceImpl
implements OrderTypeApi {
    private static final Logger log = LoggerFactory.getLogger(OrderTypeServiceImpl.class);
    @Resource
    private WOrderTypeMapper wOrderTypeMapper;
    @Resource
    private WOrderFieldMapper wOrderFieldMapper;

    public Rsp save(WOrderSaveReqBO request) {
        log.info("\u521b\u5efa/\u4fee\u6539\u8ba2\u5355\u7c7b\u578b\uff1a{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getTypeId())) {
            WOrderType orderType = new WOrderType();
            request.setTypeId(IdWorker.nextAutoIdStr());
            BeanUtils.copyProperties((Object)request, (Object)orderType);
            if (StringUtils.isNotEmpty((CharSequence)request.getParentId())) {
                orderType.setLevel(Integer.valueOf(1));
            }
            this.wOrderTypeMapper.insertSelective(orderType);
            this.saveFields(request.getFields(), request.getTypeId());
        } else {
            if (StringUtils.isNotEmpty((CharSequence)request.getIsValid()) && request.getIsValid().equals(EntityValidType.DELETE.getCode())) {
                WOrderType cond = new WOrderType();
                cond.setParentId(request.getTypeId());
                cond.setIsValid(EntityValidType.NORMAL.getCode());
                List level2Types = this.wOrderTypeMapper.selectAll(cond);
                if (CollectionUtils.isNotEmpty((Collection)level2Types)) {
                    return BaseRspUtils.createErrorRsp((String)"\u8be5\u7c7b\u578b\u4e0b\u5b58\u5728\u4e8c\u7ea7\u7c7b\u578b\uff0c\u4e0d\u80fd\u5220\u9664");
                }
            }
            WOrderType orderType = new WOrderType();
            BeanUtils.copyProperties((Object)request, (Object)orderType);
            orderType.setUpdateTime(new Date());
            this.wOrderTypeMapper.update(orderType);
            if (CollectionUtils.isNotEmpty((Collection)request.getFields())) {
                this.wOrderFieldMapper.deleteByOrderId(request.getTypeId());
                this.saveFields(request.getFields(), request.getTypeId());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)request.getTypeId());
    }

    public RspList list(WOrderTypeReqBO request) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u7c7b\u578b\u5217\u8868:{}", (Object)request);
        WOrderType cond = new WOrderType();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setTenantCode(null);
        cond.setUserId(null);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page typeList = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.wOrderTypeMapper.selectByCond(cond);
        ArrayList<WOrderTypeRspBO> res = new ArrayList<WOrderTypeRspBO>();
        for (WOrderType record : typeList) {
            WOrderTypeRspBO bo = new WOrderTypeRspBO();
            bo.setTypeId(record.getTypeId());
            bo.setTypeStatus(record.getTypeStatus());
            bo.setCreateTime(record.getCreateTime());
            if (record.getLevel() == 0) {
                bo.setLevel1TypeName(record.getName());
            }
            if (record.getLevel() == 1) {
                bo.setParentTypeId(record.getParentId());
                WOrderType orderType = this.wOrderTypeMapper.queryById(record.getParentId());
                bo.setLevel1TypeName(orderType.getName());
                bo.setLevel2TypeName(record.getName());
            }
            bo.setFields(this.retrieveFields(record.getTypeId()));
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res, (long)typeList.getTotal());
    }

    public RspList typeTree(WOrderTypeReqBO request) {
        WOrderType cond = new WOrderType();
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTypeStatus(EntityValidType.NORMAL.getCode());
        List types = this.wOrderTypeMapper.selectAll(cond);
        types = types.stream().sorted(Comparator.comparing(WOrderType::getLevel)).collect(Collectors.toList());
        ArrayList<WOrderTypeEntity> res = new ArrayList<WOrderTypeEntity>();
        HashMap<String, WOrderTypeEntity> map = new HashMap<String, WOrderTypeEntity>();
        for (WOrderType type : types) {
            WOrderTypeEntity entity;
            if (type.getLevel() == 0) {
                entity = WOrderTypeEntity.builder().typeId(type.getTypeId()).name(type.getName()).children(new ArrayList()).build();
                res.add(entity);
                map.put(type.getTypeId(), entity);
            }
            if (type.getLevel() != 1) continue;
            entity = WOrderTypeEntity.builder().typeId(type.getTypeId()).name(type.getName()).build();
            if (!map.containsKey(type.getParentId())) continue;
            WOrderTypeEntity orderType = (WOrderTypeEntity)map.get(type.getParentId());
            orderType.getChildren().add(entity);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList fieldList(WOrderTypeReqBO request) {
        ArrayList res = new ArrayList();
        WOrderField field = WOrderField.builder().orderTypeId(request.getTypeId()).isValid(EntityValidType.NORMAL.getCode()).build();
        List wOrderFields = this.wOrderFieldMapper.selectAll(field);
        NiccCommonUtil.copyList((List)wOrderFields, res, WOrderFieldBO.class);
        return BaseRspUtils.createSuccessRspList(res);
    }

    public List<WOrderFieldBO> retrieveFields(String typeId) {
        WOrderField field = WOrderField.builder().orderTypeId(typeId).isValid(EntityValidType.NORMAL.getCode()).build();
        List wOrderFields = this.wOrderFieldMapper.selectAll(field);
        ArrayList<WOrderFieldBO> res = new ArrayList<WOrderFieldBO>();
        NiccCommonUtil.copyList((List)wOrderFields, res, WOrderFieldBO.class);
        return res;
    }

    public void saveFields(List<WOrderFieldBO> fields, String typeId) {
        WOrderField po = WOrderField.builder().build();
        for (WOrderFieldBO field : fields) {
            BeanUtils.copyProperties((Object)field, (Object)po);
            po.setFieldId(IdWorker.nextAutoIdStr());
            po.setOrderTypeId(typeId);
            po.setLength(field.getLength());
            po.setOrderIndex(Integer.valueOf(fields.indexOf(field)));
            this.wOrderFieldMapper.insertSelective(po);
        }
    }
}

