/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.pypttool.base;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class BeanUtil {
    public static <T> T copyProperties(T orig, T dest, Class<?> clazz, boolean ignoreNull) {
        Field[] fields;
        if (orig == null || dest == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(orig.getClass())) {
            return null;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(orig);
                if (!(Modifier.isFinal(field.getModifiers()) || ignoreNull && value == null)) {
                    field.set(dest, value);
                }
                field.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (clazz.getSuperclass() == Object.class) {
            return dest;
        }
        return BeanUtil.copyProperties(orig, dest, clazz.getSuperclass(), ignoreNull);
    }

    public static <T> T copyProperties(T orig, T dest, boolean ignoreNull) {
        if (orig == null || dest == null) {
            return null;
        }
        return BeanUtil.copyProperties(orig, dest, orig.getClass(), ignoreNull);
    }

    public static <T> T clone(T src) {
        if (src == null) {
            return null;
        }
        T newObject = null;
        try {
            newObject = (T)src.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BeanUtil.copyProperties(src, newObject, false);
    }
}

