/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.access.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostUploadFile(String url, File file, Map<String, String> map) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String jsonStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            ContentType contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)StandardCharsets.UTF_8);
            FileBody bin = new FileBody(file);
            multipartEntityBuilder.addPart("file", (ContentBody)bin);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)new StringBody(entry.getValue(), contentType));
            }
            HttpEntity reqEntity = multipartEntityBuilder.build();
            httpPost.setEntity(reqEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("\u8fd4\u56de\u4fe1\u606f:{}", (Object)jsonStr);
            } else {
                log.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
            String string = jsonStr;
            HttpUtils.httpClose(httpClient, (HttpResponse)response);
            return string;
        }
        catch (IOException e) {
            log.error("post\u8bf7\u6c42\u63d0\u4ea4\u5f02\u5e38:" + url, (Throwable)e);
        }
        finally {
            HttpUtils.httpClose(httpClient, response);
        }
        return jsonStr;
    }

    private static void httpClose(CloseableHttpClient httpClient, HttpResponse response) {
        try {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> map) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String jsonStr = null;
        CloseableHttpResponse response = null;
        try {
            StringBuilder param = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                param.append("?").append(entry.getKey()).append("=").append(entry.getValue());
            }
            HttpGet httpGet = new HttpGet(url + param.toString());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("\u8fd4\u56de\u4fe1\u606f:{}", (Object)jsonStr);
            } else {
                log.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpGet.getURI());
            }
            String string = jsonStr;
            HttpUtils.httpClose(httpClient, (HttpResponse)response);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            HttpUtils.httpClose(httpClient, response);
        }
        return jsonStr;
    }
}

