/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.aliprv.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.aliprv.util.AliETSignUtil;
import com.tydic.nicc.aliprv.util.AliYunHttpUtils;
import com.tydic.nicc.aliprv.util.bo.HttpRspBo;
import com.tydic.nicc.robot.service.busi.UserResAuthService;
import com.tydic.nicc.robot.service.busi.bo.UserResAuthReqBo;
import com.tydic.nicc.robot.service.busi.bo.UserResAuthRspBo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserResAuthServiceImpl
implements UserResAuthService {
    private static final Logger log = LoggerFactory.getLogger(UserResAuthServiceImpl.class);
    @Value(value="${gs.xiaomi.url}")
    private String GS_XIAOMI_URL;
    @Value(value="${gs.xiaomi.create.user}")
    private String GS_XIAOMI_CREATE_USER;
    @Value(value="${gs.xiaomi.access.key.id}")
    private String GS_XIAOMI_ACCESS_KEY_ID;
    @Value(value="${gs.xiaomi.access.version}")
    private String GS_XIAOMI_ACCESS_VERSION;
    @Value(value="${gs.xiaomi.tenant.id}")
    private String GS_XIAOMI_TENANT_ID;
    @Value(value="${gs.xiaomi.descrebe.user}")
    private String GS_XIAOMI_DESCRIBE_USER;
    @Value(value="${gs.xiaomi.add.user.source.auth}")
    private String GS_XIAOMI_ADD_USER_SOURCE_AUTH;

    public UserResAuthRspBo addUserResAuth(UserResAuthReqBo userResAuthReqBo) {
        Object[] array;
        UserResAuthRspBo rspBO = new UserResAuthRspBo();
        log.info("\u7528\u6237\u8d44\u6e90\u6388\u6743 \u5165\u53c2\uff1a{}", (Object)userResAuthReqBo.toString());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Action", this.GS_XIAOMI_ADD_USER_SOURCE_AUTH);
        hashMap.put("Version", this.GS_XIAOMI_ACCESS_VERSION);
        hashMap.put("AccessKeyId", this.GS_XIAOMI_ACCESS_KEY_ID);
        hashMap.put("UserId", userResAuthReqBo.getUserId());
        hashMap.put("ResourceId", userResAuthReqBo.getResourceId());
        hashMap.put("ResourceType", userResAuthReqBo.getResourceType());
        List resourceIds = userResAuthReqBo.getResourceIds();
        if (resourceIds != null) {
            array = new Long[resourceIds.size()];
            for (int i = 0; i < resourceIds.size(); ++i) {
                array[i] = (Long)resourceIds.get(i);
            }
            hashMap.put("ResourceIds", Arrays.toString(array));
        } else {
            array = new Long[]{};
            hashMap.put("ResourceIds", Arrays.toString(array));
        }
        String sendGet = "";
        try {
            String param = AliETSignUtil.getParams(hashMap);
            log.info("\u7528\u6237\u8d44\u6e90\u6388\u6743\u8c03\u7528\u5c0f\u871c \u5165\u53c2\uff1a{}", (Object)param);
            HttpRspBo httpRspBo = AliYunHttpUtils.doGet(this.GS_XIAOMI_URL, param);
            Integer statusCode = httpRspBo.getStatusCode();
            sendGet = httpRspBo.getResponseEntity();
            log.info("\u7528\u6237\u8d44\u6e90\u6388\u6743\u8c03\u7528\u5c0f\u871c \u54cd\u5e94\u7801={},\u7ed3\u679c\uff1a{}", (Object)statusCode, (Object)sendGet);
            JSONObject jsonObject = JSON.parseObject((String)sendGet);
            String message = jsonObject.getString("message");
            if (statusCode == 400) {
                rspBO.setCode("9999");
                rspBO.setMessage("\u53c2\u6570\u65e0\u6548");
                log.info("\u67e5\u8be2\u77e5\u8bc6\u7c7b\u76ee \u51fa\u53c2\uff1a{}", (Object)rspBO.toString());
                return rspBO;
            }
            if (statusCode == 500) {
                rspBO.setCode("9999");
                rspBO.setMessage(message);
                log.info("\u67e5\u8be2\u77e5\u8bc6\u7c7b\u76ee \u51fa\u53c2\uff1a{}", (Object)rspBO.toString());
                return rspBO;
            }
            if (statusCode == 200) {
                rspBO.setCode("0000");
                rspBO.setMessage("\u6210\u529f\uff01");
                log.info("\u67e5\u8be2\u77e5\u8bc6\u7c7b\u76ee \u51fa\u53c2\uff1a{}", (Object)rspBO.toString());
                return rspBO;
            }
        }
        catch (Exception e) {
            rspBO.setCode("9999");
            rspBO.setMessage("\u7528\u6237\u8d44\u6e90\u6388\u6743\u8c03\u7528\u5c0f\u871c\u5931\u8d25");
            log.info("\u7528\u6237\u8d44\u6e90\u6388\u6743\u8c03\u7528\u5c0f\u871c\u5931\u8d25");
            log.error(e.getMessage(), (Throwable)e);
        }
        return rspBO;
    }
}

