/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.aliprv.util;

import com.tydic.nicc.aliprv.util.AESDecode;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class AliETSignUtil {
    private static final String ENCODING = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(AliETSignUtil.class);

    public static String getSolrDate(Date date) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
        sdf2.setTimeZone(TimeZone.getTimeZone("UTC"));
        String result = sdf1.format(date) + "T" + sdf2.format(date) + "Z";
        return result;
    }

    public static HashMap<String, Object> transBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                if (key != null && key != "") {
                    key = key.substring(0, 1).toUpperCase() + key.substring(1);
                }
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("transBean2Map Error " + e);
        }
        return map;
    }

    public static HashMap<String, Object> convertToMap(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            String varName = fields[i].getName();
            boolean accessFlag = fields[i].isAccessible();
            fields[i].setAccessible(true);
            Object o = fields[i].get(obj);
            if (o != null) {
                map.put(varName, o.toString());
            }
            fields[i].setAccessible(accessFlag);
        }
        return map;
    }

    public static String getSignature(String method, HashMap<String, Object> params, String akSecret) throws IOException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(params);
        Set entrys = sortedParams.entrySet();
        StringBuilder CanonicalizedQueryString = new StringBuilder();
        for (Map.Entry param : entrys) {
            if (param.getValue() == null || "".equals(((String)param.getKey()).trim()) || "Signature".equals(((String)param.getKey()).trim()) || "".equals(param.getValue().toString().trim())) continue;
            CanonicalizedQueryString.append(((String)param.getKey()).trim()).append("=").append(URLEncoder.encode(param.getValue().toString().trim(), ENCODING)).append("&");
        }
        String signStr = method + "&" + AliETSignUtil.percentEncode("/") + "&" + AliETSignUtil.percentEncode(CanonicalizedQueryString.toString().substring(0, CanonicalizedQueryString.toString().length() - 1));
        System.out.println("\u52a0\u5bc6\u7684\u53c2\u6570\u5b57\u7b26\u4e32\uff1a" + signStr);
        try {
            String sign = AESDecode.HMACSha1(signStr, akSecret + "&");
            return sign;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String getParams(HashMap<String, Object> params) throws IOException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(params);
        Set entrys = sortedParams.entrySet();
        StringBuilder baseString = new StringBuilder();
        for (Map.Entry param : entrys) {
            if (param.getValue() == null || "".equals(((String)param.getKey()).trim()) || "".equals(((String)param.getKey()).trim()) || "".equals(param.getValue().toString().trim())) continue;
            baseString.append(((String)param.getKey()).trim()).append("=").append(URLEncoder.encode(param.getValue().toString().trim(), ENCODING)).append("&");
        }
        return baseString.deleteCharAt(baseString.length() - 1).toString();
    }

    public String get(String url, Map<String, Object> params) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        params.forEach((key, value) -> builder.queryParam(key, new Object[]{value}));
        return builder.build().encode().toUri().toString();
    }
}

