/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.robot.base;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.nicc.cache.CacheOpr;
import com.tydic.nicc.cache.pojo.CustPojo;
import com.tydic.nicc.cache.pojo.RobotCachePojo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpCacheImpl
implements CacheOpr {
    @Autowired
    private CacheClient cacheClient;

    @Override
    public CustPojo getRobotCache(String robotIspCode) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_ACCOUNT_");
        buf.append(robotIspCode);
        CustPojo pojo = (CustPojo)this.cacheClient.get(buf.toString(), CustPojo.class);
        return pojo;
    }

    @Override
    public Boolean setRobotInstance(String tenantCode, String instanceId, RobotCachePojo robotCachePojo) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        this.cacheClient.set(buf.toString(), (Object)robotCachePojo);
        return true;
    }

    @Override
    public RobotCachePojo getRobotInstance(String tenantCode, String instanceId) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        RobotCachePojo robotCachePojo = (RobotCachePojo)this.cacheClient.get(buf.toString(), RobotCachePojo.class);
        return robotCachePojo;
    }

    @Override
    public Boolean delRobotInstance(String tenantCode, String instanceId) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        this.cacheClient.delete(buf.toString());
        return true;
    }

    @Override
    public String qryIntelligentRecommendKeepSessionId(Long custId) {
        String sessionId = (String)this.cacheClient.get("ol_cust_recommend_session_id_" + custId, String.class);
        return sessionId;
    }

    @Override
    public void setIntelligentRecommendKeepSessionId(Long custId, String sessionId) {
        this.cacheClient.set("ol_cust_recommend_session_id_" + custId, (Object)sessionId);
    }
}

