/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.robot.base;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.nicc.cache.RobotCacheOpr;
import com.tydic.nicc.cache.pojo.CustPojo;
import com.tydic.nicc.cache.pojo.LinkTypePojo;
import com.tydic.nicc.cache.pojo.LinkUrlPojo;
import com.tydic.nicc.cache.pojo.RobotCachePojo;
import com.tydic.nicc.cache.pojo.SessionRelaPojo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpCacheImpl
implements RobotCacheOpr {
    @Autowired
    private CacheClient cacheClient;

    @Override
    public CustPojo getRobotCache(String robotIspCode) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_ACCOUNT_");
        buf.append(robotIspCode);
        CustPojo pojo = (CustPojo)this.cacheClient.get(buf.toString(), CustPojo.class);
        return pojo;
    }

    @Override
    public Boolean setRobotInstance(String tenantCode, String instanceId, RobotCachePojo robotCachePojo) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        this.cacheClient.set(buf.toString(), (Object)robotCachePojo);
        return true;
    }

    @Override
    public RobotCachePojo getRobotInstance(String tenantCode, String instanceId) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        RobotCachePojo robotCachePojo = (RobotCachePojo)this.cacheClient.get(buf.toString(), RobotCachePojo.class);
        return robotCachePojo;
    }

    @Override
    public Boolean delRobotInstance(String tenantCode, String instanceId) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_INSTANCE_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(instanceId);
        this.cacheClient.delete(buf.toString());
        return true;
    }

    @Override
    public String qryIntelligentRecommendKeepSessionId(Long custId) {
        String sessionId = (String)this.cacheClient.get("ol_cust_recommend_session_id_" + custId, String.class);
        return sessionId;
    }

    @Override
    public void setIntelligentRecommendKeepSessionId(Long custId, String sessionId) {
        this.cacheClient.set("ol_cust_recommend_session_id_" + custId, (Object)sessionId);
    }

    @Override
    public boolean setSessionRelaCache(String tenantCode, String sessionCode, SessionRelaPojo sessionRelaPojo) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_SESSION_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(sessionCode);
        this.cacheClient.set(buf.toString(), (Object)sessionRelaPojo, 1800);
        return true;
    }

    @Override
    public SessionRelaPojo getSessionRelaCache(String tenantCode, String sessionCode) {
        StringBuffer buf = new StringBuffer();
        buf.append("ROBOT_SESSION_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(sessionCode);
        return (SessionRelaPojo)this.cacheClient.get(buf.toString(), SessionRelaPojo.class);
    }

    @Override
    public boolean setHyperLinkSessionCache(String tenantCode, String linkId, String hyperlink) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkId);
        this.cacheClient.set(buf.toString(), (Object)hyperlink);
        return true;
    }

    @Override
    public String getHyperLinkSessionCache(String tenantCode, String linkId) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkId);
        return (String)this.cacheClient.get(buf.toString(), String.class);
    }

    @Override
    public boolean delHyperLinkSessionCache(String tenantCode, String linkId) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkId);
        this.cacheClient.delete(buf.toString());
        return true;
    }

    @Override
    public LinkTypePojo getLinkTypeSessionCache(String tenantCode) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(tenantCode);
        return (LinkTypePojo)this.cacheClient.get(buf.toString(), LinkTypePojo.class);
    }

    @Override
    public boolean delLinkTypeSessionCache(String tenantCode) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(tenantCode);
        this.cacheClient.delete(buf.toString());
        return true;
    }

    @Override
    public boolean setLinkTypeSessionCache(String tenantCode, LinkTypePojo linkTypePojo) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(tenantCode);
        this.cacheClient.set(buf.toString(), (Object)linkTypePojo);
        return true;
    }

    @Override
    public LinkUrlPojo getLinkUrlSessionCache(String tenantCode, String linkTitle) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkTitle);
        return (LinkUrlPojo)this.cacheClient.get(buf.toString(), LinkUrlPojo.class);
    }

    @Override
    public boolean setLinkUrlSessionCache(String tenantCode, String linkTitle, LinkUrlPojo linkUrlPojo) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkTitle);
        this.cacheClient.set(buf.toString(), (Object)linkUrlPojo);
        return true;
    }

    @Override
    public boolean delLinkUrlSessionCache(String tenantCode, String linkTitle) {
        StringBuffer buf = new StringBuffer();
        buf.append("hyperlink_");
        buf.append(tenantCode);
        buf.append("_");
        buf.append(linkTitle);
        this.cacheClient.delete(buf.toString());
        return true;
    }
}

