/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.pipeline;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.ChineseCharactersUtils;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.vo.JdCategoryVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JdCategoryPipeline {
    private static final Logger log = LoggerFactory.getLogger(JdCategoryPipeline.class);
    @Resource
    private CategoryMapper categoryMapper;

    public void process(Map<String, List<Map<String, List<JdCategoryVO>>>> map) {
        Set<String> keySet = map.keySet();
        ArrayList<CategoryPO> categoryPOList = new ArrayList<CategoryPO>();
        for (String key : keySet) {
            CategoryPO categoryPO = CategoryPO.builder().createdBy("kx").createdTime(new Date()).updatedTime(new Date()).level(Integer.valueOf(1)).name(key).categoryId(ChineseCharactersUtils.toPinyin(key)).sign(MallType.JD.getCode()).build();
            categoryPOList.add(categoryPO);
            if (map.get(key).size() <= 0) continue;
            List<Map<String, List<JdCategoryVO>>> list = map.get(key);
            for (Map<String, List<JdCategoryVO>> map2 : list) {
                Set<String> keySet2 = map2.keySet();
                for (String key2 : keySet2) {
                    CategoryPO categoryPO2 = CategoryPO.builder().createdBy("kx").createdTime(new Date()).updatedTime(new Date()).level(Integer.valueOf(2)).name(key2).categoryId(ChineseCharactersUtils.toPinyin(key2)).sign(MallType.JD.getCode()).pater(categoryPO.getCategoryId()).build();
                    categoryPOList.add(categoryPO2);
                    if (map2.get(key2).size() <= 0) continue;
                    List<JdCategoryVO> jdCategoryVOList = map2.get(key2);
                    for (JdCategoryVO jdCategoryVO : jdCategoryVOList) {
                        String name = jdCategoryVO.getName();
                        String url = jdCategoryVO.getUrl();
                        boolean matches = url.matches("^[0-9-]+$");
                        if (matches) {
                            url = url.replace("-", ",");
                            url = "https://list.jd.com/list.html?cat=" + url.replace("-", ",") + url;
                        } else {
                            url = "https://" + url;
                        }
                        CategoryPO categoryPO3 = CategoryPO.builder().createdBy("kx").createdTime(new Date()).updatedTime(new Date()).level(Integer.valueOf(3)).name(name).categoryId(categoryPO2.getCategoryId() + "_" + ChineseCharactersUtils.toPinyin(name)).url(url).sign(MallType.JD.getCode()).pater(categoryPO2.getCategoryId()).build();
                        categoryPOList.add(categoryPO3);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(categoryPOList)) {
            List categoryListDB = this.categoryMapper.queryCategoryList(MallType.JD.getCode());
            Map<String, CategoryPO> zkhCategoryMap = categoryPOList.stream().collect(Collectors.toMap(CategoryPO::getCategoryId, zkhCategory -> zkhCategory));
            ArrayList<String> categoryIdsPO = new ArrayList<String>();
            for (CategoryPO categoryPO : categoryPOList) {
                categoryIdsPO.add(categoryPO.getCategoryId());
            }
            for (CategoryPO categoryPO : categoryListDB) {
                String categoryId = categoryPO.getCategoryId();
                if (!categoryIdsPO.contains(categoryId)) {
                    this.categoryMapper.deleteCategory(categoryPO);
                    log.info("\u5220\u9664\u7684\u6570\u636e\uff1a{}", (Object)categoryPO);
                    continue;
                }
                this.categoryMapper.updateCategory(zkhCategoryMap.get(categoryId));
                categoryIdsPO.remove(categoryId);
                log.info("\u66f4\u65b0\u7684\u6570\u636e\uff1a{}", (Object)zkhCategoryMap.get(categoryId));
            }
            if (CollectionUtils.isNotEmpty(categoryIdsPO)) {
                for (String params : categoryIdsPO) {
                    log.info("\u6dfb\u52a0\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)zkhCategoryMap.get(params));
                    this.categoryMapper.addCategory(zkhCategoryMap.get(params));
                }
                categoryIdsPO.clear();
            }
        }
    }
}

