/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.category;

import com.tydic.nicc.spider.vo.JdCategoryVO;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;

public class JdCategoryProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdCategoryProcessorWithSelfDriver.class);
    private static final String CATEGORY_URL = "https://dc.3.cn/category/get?&callback=getCategoryCallback";

    public static Map<String, List<Map<String, List<JdCategoryVO>>>> process(SelfDriver selfDriver) {
        RemoteWebDriver driver = selfDriver.getDriver();
        try {
            driver.get(CATEGORY_URL);
        }
        catch (Exception e) {
            log.info("JdCategoryProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
        }
        Html html = JdCategoryProcessorWithSelfDriver.createHtml(driver.getPageSource());
        String htmlStr = html.xpath("//body/allText()").get();
        HashMap<String, List<Map<String, List<JdCategoryVO>>>> map1 = new HashMap<String, List<Map<String, List<JdCategoryVO>>>>();
        if (StringUtils.isNotBlank((CharSequence)htmlStr)) {
            String jsonStr = htmlStr.replace("getCategoryCallback(", "").replace(")", "");
            List dataList = new JsonPathSelector("$.data").selectList(jsonStr);
            JsonPathSelector jsonPathSelector = new JsonPathSelector("$.s");
            JsonPathSelector jsonPathSelector2 = new JsonPathSelector("$.n");
            for (String dataStr : dataList) {
                List sList = jsonPathSelector.selectList(dataStr);
                ArrayList<String> nList = new ArrayList<String>();
                ArrayList<Map<String, List<JdCategoryVO>>> s2 = new ArrayList<Map<String, List<JdCategoryVO>>>();
                for (String s : sList) {
                    String n = jsonPathSelector2.select(s).split("\\|")[1];
                    nList.add(n);
                    Map<String, List<JdCategoryVO>> map2 = JdCategoryProcessorWithSelfDriver.categorty(jsonPathSelector.selectList(s));
                    if (map2 == null) continue;
                    s2.add(map2);
                }
                String n = String.join((CharSequence)"\\", nList);
                map1.put(n, s2);
            }
        }
        return map1;
    }

    private static Map<String, List<JdCategoryVO>> categorty(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        JsonPathSelector jsonPathSelector = new JsonPathSelector("$.s");
        JsonPathSelector jsonPathSelector2 = new JsonPathSelector("$.n");
        HashMap<String, List<JdCategoryVO>> map = new HashMap<String, List<JdCategoryVO>>();
        for (String s1 : list) {
            String n = jsonPathSelector2.select(s1).split("\\|")[1];
            List sList = jsonPathSelector.selectList(s1);
            ArrayList<JdCategoryVO> nList = new ArrayList<JdCategoryVO>();
            for (String s : sList) {
                String[] select = jsonPathSelector2.select(s).split("\\|");
                nList.add(new JdCategoryVO(select[0], select[1]));
            }
            map.put(n, nList);
        }
        return map;
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

