/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class GajDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(GajDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            String url = goods.getUrl();
            String result = HttpRequest.post((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u56fa\u5b89\u6377\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u56fa\u5b89\u6377\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        Html html = page.getHtml();
        List divs = html.$("div.spec-item").nodes();
        HashMap hashMap = new HashMap();
        StringBuilder commodityAttribute = new StringBuilder();
        divs.forEach(selectable -> {
            String goodsAttribute = selectable.$("span.new_class_left").xpath("///allText()").get();
            String goodsSaleAttribute = selectable.$("span.new_class").xpath("///allText()").get();
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        String introduce = html.$("div#productImg").get();
        String brandName = html.$("h1.text-2 strong:nth-child(1)").xpath("///allText()").get();
        String price = html.$("#productParams > div.newReplace > div > div.right > div > div.good-price > strong > span").xpath("///allText()").get();
        String skuId = html.$("div.newReplace > div > div.middle > div > div.spec > div:nth-child(1) > span.new_class").xpath("///allText()").get();
        String title = html.$("div.newReplace > div > div.middle > div > div.good-info-height > div > h1").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)skuId)) {
            goods.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            goods.setTitle(title);
        }
        goods.setPrefix(MallType.GAJ.getCode());
        goods.setBrandName(brandName);
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            String cleanedPrice = price.replaceAll(",", "");
            goods.setPrice(new BigDecimal(cleanedPrice));
        } else {
            log.info("\u56fd\u5b89\u6377\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
            goods.setSkuState("0");
        }
        goodsDetails.setPrefix(MallType.GAJ.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
    }

    public Site getSite() {
        return Site.me();
    }
}

