/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.ChineseCharactersUtils;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsCommentPO;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.selector.Html;

@Component
@Service
public class JdDescriptionProcessorApi {
    private static final Logger log = LoggerFactory.getLogger(JdDescriptionProcessorApi.class);
    @Value(value="${nicc-plugin.spider.isPiderComment}")
    private boolean isPiderComment;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public Map<String, Object> process(Goods paramTo) {
        String url = paramTo.getUrl();
        String skuId = JdDescriptionProcessorApi.extractPathAfterHtml(url, "/", ".html");
        if (url.contains("i-item") || url.contains("m.jd.com")) {
            url = JdDescriptionProcessorApi.normalizeJdUrl(url);
            paramTo.setUrl(url);
        }
        paramTo.setSkuId(skuId);
        String goodsNo = paramTo.getGoodsNo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            url = "https://api.m.jd.com/?appid=pc-item-soa&functionId=pc_detailpage_wareBusiness&client=pc&clientVersion=1.0.0&t=1755760699570&body=%7B%22skuId%22%3A" + skuId + "%2C%22cat%22%3A%2217329%2C2576%2C12071%22%2C%22area%22%3A%221_2812_51125_0%22%2C%22shopId%22%3A%221000477935%22%2C%22venderId%22%3A1000477935%2C%22paramJson%22%3A%22%7B%5C%22platform2%5C%22%3A%5C%221%5C%22%2C%5C%22specialAttrStr%5C%22%3A%5C%22p0ppppppppppppppppppppppppp%5C%22%2C%5C%22skuMarkStr%5C%22%3A%5C%2200%5C%22%7D%22%2C%22num%22%3A1%2C%22bbTraffic%22%3A%22%22%2C%22canvasType%22%3A1%2C%22giftServiceIsSelected%22%3A%22%22%2C%22customInfoId%22%3A%220%22%2C%22sfTime%22%3A%221%2C0%2C0%22%7D";
            HttpRequest httpRequest = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36")).header("x-referer-page", "https://item.jd.com/")).header("referer", "https://item.jd.com/")).header("x-rp-client", "h5_1.0.0")).timeout(300000);
            HttpResponse httpResponse = httpRequest.execute();
            if (httpResponse.isOk()) {
                log.info("\u8bf7\u6c42\u6210\u529f");
                String result = httpResponse.body();
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                JSONObject data = jsonObject.getJSONObject("wareInfoReadMap");
                String skuStatus = "0";
                if (data != null) {
                    String stock = "1";
                    String price = "0";
                    String costpirce = "0";
                    String title = data.getString("sku_name");
                    log.info("\u6807\u9898:" + title);
                    skuStatus = data.getString("sku_status");
                    String supplierName = data.getString("shop_name");
                    String pic = "https://img11.360buyimg.com/n1/" + data.getString("img_dfs_url");
                    String brandName = data.getString("cn_brand");
                    log.info("\u54c1\u724c:" + brandName);
                    if (StringUtils.isEmpty((CharSequence)brandName)) {
                        brandName = "\u54c1\u724c";
                    }
                    String color = data.getString("color");
                    JSONObject itemShopInfo = jsonObject.getJSONObject("itemShopInfo");
                    JSONObject priceinfo = jsonObject.getJSONObject("price");
                    if (priceinfo != null) {
                        price = priceinfo.getString("p");
                        costpirce = priceinfo.getString("op");
                    }
                    log.info("\u4ef7\u683c:" + price);
                    paramTo.setSpuName(color);
                    paramTo.setSkuState(skuStatus);
                    paramTo.setSupplierName(supplierName);
                    paramTo.setBrandName(brandName);
                    paramTo.setTitle(title);
                    paramTo.setPic(pic);
                    paramTo.setPrice(new BigDecimal(price));
                    paramTo.setCostPrice(new BigDecimal(costpirce));
                    if (StringUtils.isNotEmpty((CharSequence)skuStatus) && skuStatus.equals("1")) {
                        this.pageProcess(map, paramTo);
                    } else {
                        paramTo.setSkuState("0");
                        paramTo.setPrice(new BigDecimal("0"));
                        paramTo.setCostPrice(new BigDecimal("0"));
                    }
                } else {
                    paramTo.setSkuState("0");
                    paramTo.setPrice(new BigDecimal("0"));
                    paramTo.setCostPrice(new BigDecimal("0"));
                }
            } else {
                paramTo.setSkuState("0");
                paramTo.setPrice(new BigDecimal("0"));
                paramTo.setCostPrice(new BigDecimal("0"));
            }
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u5f02\u5e38{}", (Object)goodsNo, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", paramTo);
        return map;
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private void pageProcess(Map<String, Object> map, Goods goods) {
        Html html;
        HashMap<String, String> comment = new HashMap<String, String>();
        GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
        goods.setPrefix(MallType.JD.getCode());
        goodsDetailsWithBLOBs.setGoodsNo(goods.getGoodsNo());
        goodsDetailsWithBLOBs.setPrefix(MallType.JD.getCode());
        String skuId = goods.getSkuId();
        HttpResponse response = null;
        String skuAttrNames = "";
        String skuAttrJson = "";
        String skuSaleAttrNames = "";
        try {
            response = HttpRequest.get((String)goods.getUrl()).execute();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        if (response != null && response.isOk()) {
            List nodes1;
            List nodes;
            html = new Html(response.body().toString());
            String categoryName = html.$("#crumb-wrap > div > div > div:nth-child(5) > a").xpath("///allText()").get();
            if (StringUtils.isNotBlank((CharSequence)categoryName)) {
                try {
                    goods.setCategoryId(ChineseCharactersUtils.toPinyin(categoryName));
                    goods.setCategoryName(categoryName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(nodes = html.$("div#choose-attrs > div.p-choose").nodes()))) {
                ArrayList saleAttrList = new ArrayList();
                nodes.forEach(node -> {
                    String saleAttr = node.xpath("///@data-type").get();
                    if (StringUtils.isNotEmpty((CharSequence)saleAttr)) {
                        saleAttrList.add(saleAttr);
                    }
                });
                skuSaleAttrNames = String.join((CharSequence)".", saleAttrList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(nodes1 = html.$("div.goods-base>div").nodes()))) {
                ArrayList attrList = new ArrayList();
                HashMap jsonMap = new HashMap();
                nodes1.forEach(node -> {
                    String attr = node.$("div.flex-center>div.name").xpath("///allText()").get();
                    String attrValue = node.$("div.adaptive>div.text").xpath("///allText()").get();
                    if (StringUtils.isNotBlank((CharSequence)attr)) {
                        attrList.add(attr);
                        jsonMap.put(attr, attrValue);
                    }
                });
                skuAttrNames = String.join((CharSequence)",", attrList);
                skuAttrJson = JSONUtil.toJsonStr(jsonMap);
            } else {
                log.info("\u83b7\u53d6\u5c5e\u6027null");
                nodes1 = html.$("div.p-parameter>ul > li[title]").nodes();
                if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
                    ArrayList attrList = new ArrayList();
                    HashMap jsonMap = new HashMap();
                    nodes1.forEach(node -> {
                        String[] split;
                        String attr = node.xpath("///allText()").get();
                        String attrValue = node.xpath("///@title").get();
                        if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{attr, attrValue}) && StringUtils.isNotBlank((CharSequence)(attr = (split = attr.split("\uff1a"))[0]))) {
                            attrList.add(attr);
                            jsonMap.put(attr, attrValue);
                        }
                    });
                    skuAttrNames = String.join((CharSequence)",", attrList);
                    skuAttrJson = JSONUtil.toJsonStr(jsonMap);
                    log.info("\u83b7\u53d6\u5c5e\u6027{}", (Object)skuAttrJson);
                }
                HashMap extJsonMap = new HashMap();
                List nodesPack = html.$("div.package-list").nodes();
                if (CollectionUtils.isNotEmpty((Collection)nodesPack)) {
                    nodesPack.forEach(node -> {
                        String na = node.$("h3").xpath("///allText()").get();
                        String value = node.$("p").xpath("///allText()").get();
                        extJsonMap.put(na, value);
                    });
                    goodsDetailsWithBLOBs.setExtJson(JSONUtil.toJsonStr(extJsonMap));
                }
            }
        } else {
            log.info("\u4eac\u4e1c\u5546\u57ceurl{}\u6570\u636e\u89e3\u6790\u5931\u8d25{}", (Object)goods.getUrl(), (Object)response.body());
            throw new DcBusinessException("\u8be6\u60c5\u91c7\u96c6\u5931\u8d25");
        }
        html = null;
        String commentStr = "";
        try {
            this.getMent(comment, skuId);
        }
        catch (Exception e) {
            log.error("\u8bc4\u4ef7\u5f02\u5e38", (Throwable)e);
        }
        if (comment != null && comment.size() > 0) {
            commentStr = JSONUtil.toJsonStr(comment);
        }
        try {
            goodsDetailsWithBLOBs.setSkuId(goods.getSkuId());
            goodsDetailsWithBLOBs.setSkuSaleAttrNames(skuSaleAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrNames(skuAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrJson(skuAttrJson);
            goodsDetailsWithBLOBs.setComment(commentStr);
            log.info("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u6210\u529f{}", (Object)goods.getGoodsNo(), (Object)goods.getUrl());
            map.put("goods", goods);
            map.put("goodsDetails", goodsDetailsWithBLOBs);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7", (Throwable)e);
        }
    }

    private void getMent(HashMap<String, String> comment, String skuId) {
        String goodRateShow = "0";
        String commentCountStr = "0";
        String imageNum = "0";
        String videoCountStr = "0";
        String afterCountStr = "0";
        String goodCountStr = "0";
        String generalCountStr = "0";
        String poorCountStr = "0";
        try {
            String result;
            String url = "https://api.m.jd.com/?functionId=pc_club_productCommentSummaries&body={\"referenceIds\":" + skuId + "}&area=14_1116_3431_57939&t=1748416861570&appid=item-v3";
            HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
            if (response.isOk() && StringUtils.isNotBlank((CharSequence)(result = response.body()))) {
                JSONObject commentsummary;
                JSONObject object = JSONObject.parseObject((String)result);
                log.info("\u8bc4\u8bbaresult" + result);
                JSONArray commentsArray = object.getJSONArray("CommentsCount");
                log.info("\u83b7\u53d6\u6570\u636e" + commentsArray);
                if (!commentsArray.isEmpty() && (commentsummary = commentsArray.getJSONObject(0)) != null) {
                    goodRateShow = commentsummary.getString("GoodRateShow");
                    commentCountStr = commentsummary.getString("CommentCountStr");
                    videoCountStr = commentsummary.getString("VideoCountStr");
                    afterCountStr = commentsummary.getString("AfterCountStr");
                    goodCountStr = commentsummary.getString("GoodCountStr");
                    generalCountStr = commentsummary.getString("GeneralCountStr");
                    poorCountStr = commentsummary.getString("PoorCountStr");
                    comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
                    comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                    comment.put("\u6652\u56fe", videoCountStr);
                    comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
                    comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
                    comment.put("\u597d\u8bc4\u6570", goodCountStr);
                    comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
                    comment.put("\u5dee\u8bc4\u6570", poorCountStr);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bc4\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    private int goodsComment(String goodNo, int page, HashMap<String, String> comment) {
        String result;
        String url = "https://api.m.jd.com/?appid=item-v3&functionId=pc_club_skuProductPageComments&client=pc&clientVersion=1.0.0&loginType=3&productId=" + goodNo + "&score=0&sortType=5&page=" + page + "&pageSize=10&isShadowSku=0&fold=1&bbtf=&shield=";
        HttpResponse response = HttpRequest.get((String)url).execute();
        int totalPage = 0;
        if (response.isOk() && StringUtils.isNotBlank((CharSequence)(result = response.body()))) {
            JSONArray list;
            JSONArray jsonObject;
            JSONObject object = JSONObject.parseObject((String)result);
            totalPage = object.getInteger("maxPage");
            int n = totalPage = totalPage > 100 ? 100 : totalPage;
            if (totalPage == 0) {
                return totalPage;
            }
            if (page == 0 && totalPage > 0) {
                String imageNum = object.getString("imageListCount");
                JSONObject commentsummary = object.getJSONObject("productCommentSummary");
                if (commentsummary != null) {
                    String goodRateShow = commentsummary.getString("goodRateShow");
                    String commentCountStr = commentsummary.getString("commentCountStr");
                    String videoCountStr = commentsummary.getString("videoCountStr");
                    String afterCountStr = commentsummary.getString("afterCountStr");
                    String goodCountStr = commentsummary.getString("goodCountStr");
                    String generalCountStr = commentsummary.getString("generalCountStr");
                    String poorCountStr = commentsummary.getString("poorCountStr");
                    comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
                    comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                    comment.put("\u6652\u56fe", imageNum);
                    comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
                    comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
                    comment.put("\u597d\u8bc4\u6570", goodCountStr);
                    comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
                    comment.put("\u5dee\u8bc4\u6570", poorCountStr);
                }
                Object commentTag = object.get((Object)"hotCommentTagStatistics");
                String statistics = "";
                if (commentTag != null) {
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    JSONArray list2 = JSONObject.parseArray((String)commentTag.toString(), (Feature[])new Feature[0]);
                    for (Map map : list2) {
                        map1.put(map.get("name").toString(), map.get("count").toString());
                    }
                    statistics = JSONUtil.toJsonStr(map1);
                } else {
                    statistics = "\u6682\u65e0\u4e70\u5bb6\u5370\u8c61";
                }
                comment.put("\u4e70\u5bb6\u5370\u8c61", statistics);
            }
            if ((jsonObject = object.getJSONArray("comments")) != null && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0])))) {
                ArrayList<GoodsCommentPO> goodsCommentPOS = new ArrayList<GoodsCommentPO>();
                for (Map map : list) {
                    GoodsCommentPO commentPO = new GoodsCommentPO();
                    commentPO.setPrefix(MallType.JD.getCode());
                    commentPO.setCreatetime(new Date());
                    commentPO.setUpdatetime(new Date());
                    if (map.get("nickname") != null) {
                        commentPO.setUserName(map.get("nickname").toString());
                    }
                    if (map.get("id") != null) {
                        commentPO.setCommentId(map.get("id").toString());
                    }
                    if (map.get("content") != null) {
                        commentPO.setCommentCon(map.get("content").toString());
                    }
                    if (map.get("creationTime") != null) {
                        commentPO.setCommentTime(map.get("creationTime").toString());
                    }
                    if (map.get("productColor") != null && map.get("productSize") != null) {
                        commentPO.setGoodAttr(map.get("productColor") + "  " + map.get("productSize"));
                    }
                    commentPO.setGoodsNo(goodNo);
                    if (map.get("location") != null) {
                        commentPO.setLocation(map.get("location").toString());
                    }
                    if (map.get("plusAvailable") != null) {
                        commentPO.setPlusAvailable(map.get("plusAvailable").toString());
                    }
                    if (map.get("replyCount") != null) {
                        commentPO.setSpriteComment(map.get("replyCount").toString());
                    }
                    if (map.get("topped") != null) {
                        commentPO.setSpritePraise(map.get("topped").toString());
                    }
                    if (map.get("score") != null) {
                        commentPO.setStar(map.get("score").toString());
                    }
                    goodsCommentPOS.add(commentPO);
                }
                this.executorService.submit(() -> this.processDataPipeline.processDataList(goodsCommentPOS));
            }
        }
        return totalPage;
    }

    private List<String> url(String skuId, String html) {
        String url = "https://api.m.jd.com/description/channel?appid=item-v3&functionId=pc_description_channel&client=pc&clientVersion=1.0.0&skuId=" + skuId;
        HttpResponse httpResponse = null;
        List<String> urlList = new ArrayList<String>();
        try {
            httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
            if (httpResponse != null && httpResponse.isOk()) {
                JSONObject jsonObject = JSONObject.parseObject((String)httpResponse.body());
                html = jsonObject.get((Object)"content").toString();
                urlList = JdDescriptionProcessorApi.extractLinks(html);
            } else {
                log.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25{}" + httpResponse.body());
            }
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
        }
        return urlList;
    }

    public static List<String> extractLinks(String html) {
        ArrayList<String> links = new ArrayList<String>();
        if (html == null || html.isEmpty()) {
            return links;
        }
        String decodedHtml = html.replace("&quot;", "\"");
        Pattern bgPattern = Pattern.compile("background-image:\\s*url\\s*\\(\\s*['\"]?([^)'\"]+)['\"]?\\s*\\)", 2);
        Pattern lazyPattern = Pattern.compile("data-lazyload\\s*=\\s*['\"]\\s*([^'\"]+)\\s*['\"]", 2);
        Matcher bgMatcher = bgPattern.matcher(decodedHtml);
        while (bgMatcher.find()) {
            String url = JdDescriptionProcessorApi.processUrl(bgMatcher.group(1));
            links.add(url);
        }
        Matcher lazyMatcher = lazyPattern.matcher(decodedHtml);
        while (lazyMatcher.find()) {
            String url = JdDescriptionProcessorApi.processUrl(lazyMatcher.group(1));
            links.add(url);
        }
        return links;
    }

    private static String processUrl(String rawUrl) {
        String url = rawUrl.trim();
        if (url.startsWith("//")) {
            url = "https:" + url;
        }
        if (url.endsWith(".avif")) {
            url = url.substring(0, url.length() - 5);
        }
        return url;
    }

    public static String normalizeJdUrl(String originalUrl) {
        String cleanUrl;
        Pattern JD_ITEM_PATTERN = Pattern.compile("https?://(?:[\\w-]+\\.)?(?:item|m|\\w+-item)\\.jd\\.com(?:/[^/?#]+)*/(\\d+)(?:\\.html)?", 2);
        Matcher matcher = JD_ITEM_PATTERN.matcher(cleanUrl = originalUrl.split("[?#]")[0]);
        if (matcher.find()) {
            String productId = matcher.group(1);
            return "https://item.jd.com/" + productId + ".html";
        }
        Pattern DIRECT_ID_PATTERN = Pattern.compile("https?://item\\.jd\\.com/(\\d+)(?:\\.html)?", 2);
        matcher = DIRECT_ID_PATTERN.matcher(cleanUrl);
        if (matcher.find()) {
            return "https://item.jd.com/" + matcher.group(1) + ".html";
        }
        return originalUrl;
    }

    public static String extractPathAfterHtml(String url, String lastIndex, String index) {
        int comIndex = url.lastIndexOf(lastIndex);
        if (comIndex == -1) {
            return "";
        }
        String afterCom = url.substring(comIndex + lastIndex.length());
        int htmlIndex = afterCom.indexOf(index);
        if (htmlIndex == -1) {
            return afterCom;
        }
        return afterCom.substring(0, htmlIndex);
    }
}

