/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsCommentPO;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.selector.Html;

@Component
@Service
public class JdDescriptionProcessorNewWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdDescriptionProcessorNewWithSelfDriver.class);
    @Value(value="${nicc-plugin.spider.isPiderComment}")
    private boolean isPiderComment;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public Map<String, Object> process(RemoteWebDriver driver, Goods paramTo) {
        String url = paramTo.getUrl();
        String goodsNo = paramTo.getGoodsNo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String skuId = JdDescriptionProcessorNewWithSelfDriver.extractPathAfterHtml(url, "/", ".html");
        paramTo.setSkuId(skuId);
        try {
            driver.get(url);
            if (StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://www.jd.com/?") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://passport.jd.com/") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://cfe.m.jd.com")) {
                log.info("\u5546\u54c1\u5df2\u4e0b\u67b6\u5f53\u524durl:" + driver.getCurrentUrl());
                paramTo.setSkuState("0");
                paramTo.setPrice(new BigDecimal("0"));
                paramTo.setTitle("\u5546\u54c1\u5df2\u4e0b\u67b6");
                paramTo.setSkuId(skuId);
            } else {
                Html html = this.newHtml(driver);
                this.pageProcess(map, html, paramTo, driver);
            }
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u5f02\u5e38{},driver{}", new Object[]{goodsNo, e, driver});
            throw e;
        }
        map.put("goods", paramTo);
        return map;
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private void pageProcess(Map<String, Object> map, Html html, Goods goods, RemoteWebDriver driver) {
        String title;
        HashMap<String, String> comment = new HashMap<String, String>();
        String goodsno = goods.getGoodsNo();
        GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
        goods.setPrefix(MallType.JD.getCode());
        goodsDetailsWithBLOBs.setGoodsNo(goods.getGoodsNo());
        goodsDetailsWithBLOBs.setPrefix(MallType.JD.getCode());
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        String price = null;
        String priceStr = null;
        String dailyPrice = null;
        String str = html.$("div.itemover-tip").xpath("///allText()").get();
        if (StringUtils.isBlank((CharSequence)str)) {
            try {
                WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div.itemover-tip")));
                str = element.getText();
            }
            catch (Exception element) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((CharSequence)(title = html.$("div.sku-name").xpath("///allText()").get()))) {
            title = html.$("span.sku-title-name").xpath("///allText()").get();
        }
        goods.setTitle(title);
        String skuId = html.$("a.compare.J-compare.J_contrast").xpath("///@data-sku").get();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            goods.setSkuState("0");
            goods.setPrice(new BigDecimal("0"));
            return;
        }
        goods.setSkuState("1");
        try {
            price = html.$("span.p-price > span:nth-child(2)").xpath("///allText()").get();
            for (int num = 1; StringUtils.isEmpty((CharSequence)price) && num <= 3; ++num) {
                try {
                    WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"span.p-price > span:nth-child(2)")));
                    price = element.getText();
                    continue;
                }
                catch (Exception element) {
                    // empty catch block
                }
            }
        }
        catch (Exception num) {
            // empty catch block
        }
        html = this.newHtml(driver);
        dailyPrice = html.$("#J_DailyPrice> span:nth-child(2)").xpath("///allText()").get();
        priceStr = html.$("#J_FinalPrice > span.price").xpath("///allText()").get();
        log.info("\u4ef7\u683c:" + price);
        if (StringUtils.isNotBlank((CharSequence)price) && !price.equals("\u6682\u65e0\u62a5\u4ef7") && ProcessRegexUtil.processJdPrice(price)) {
            if (StringUtils.isNotEmpty((CharSequence)priceStr)) {
                goods.setPrice(new BigDecimal(priceStr));
            } else {
                goods.setPrice(new BigDecimal(price));
            }
            if (StringUtils.isNotEmpty((CharSequence)dailyPrice)) {
                goods.setCostPrice(new BigDecimal(dailyPrice));
            } else {
                goods.setCostPrice(new BigDecimal(price));
            }
        } else {
            goods.setPrice(new BigDecimal(0));
        }
        log.info("\u6807\u9898:" + title);
        String categoryName = html.$("#crumb-wrap > div > div > div:nth-child(7) > a").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            goods.setCategoryId("1");
            goods.setCategoryName(categoryName);
        }
        log.info("\u5206\u7c7b:" + categoryName);
        List nodes = html.$("div#choose-attrs > div.p-choose").nodes();
        String skuSaleAttrNames = "";
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            ArrayList saleAttrList = new ArrayList();
            nodes.forEach(node -> {
                String saleAttr = node.xpath("///@data-type").get();
                if (StringUtils.isNotEmpty((CharSequence)saleAttr)) {
                    saleAttrList.add(saleAttr);
                }
            });
            skuSaleAttrNames = String.join((CharSequence)".", saleAttrList);
        }
        String item1 = html.$("#choose-attr-1 > div.dd > div.item.selected > a").xpath("///allText()").get();
        String item2 = html.$("#choose-attr-2 > div.dd > div.item.selected > a").xpath("///allText()").get();
        log.info("\u5177\u4f53\u9500\u552e\u5c5e\u6027:" + item1);
        String supplierName = html.$("div.top-shop-info > div.top-name-tag > div.top-name").xpath("///allText()").get();
        if (StringUtils.isEmpty((CharSequence)supplierName)) {
            supplierName = html.$("div.detail-shop > div.name-tag > div.name").xpath("///allText()").get();
        }
        log.info("\u5e97\u94fa\u540d:" + supplierName);
        String brandName = html.$("#product-attribute > div > div:nth-child(1) > div.value > div > a").xpath("///allText()").get();
        log.info("brandName:" + brandName);
        String picUrl = html.$("#spec-img").xpath("///@src").get();
        if (StringUtils.isNotBlank((CharSequence)picUrl)) {
            goods.setPic(picUrl);
        }
        log.info("picUrl:" + picUrl);
        String skuAttrNames = "";
        String skuAttrJson = "";
        List nodes1 = html.$("div.goods-base>div").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
            ArrayList attrList = new ArrayList();
            HashMap jsonMap = new HashMap();
            nodes1.forEach(node -> {
                String attr = node.$("div.flex-center>div.name").xpath("///allText()").get();
                String attrValue = node.$("div.adaptive>div.text").xpath("///allText()").get();
                attrList.add(attr);
                jsonMap.put(attr, attrValue);
            });
            skuAttrNames = String.join((CharSequence)",", attrList);
            skuAttrJson = JSONUtil.toJsonStr(jsonMap);
            if (StringUtils.isEmpty((CharSequence)skuId)) {
                skuId = (String)jsonMap.get("\u5546\u54c1\u7f16\u53f7");
            }
        }
        log.info("\u8be6\u60c5:" + skuAttrJson);
        if (StringUtils.isBlank((CharSequence)skuId)) {
            Pattern pattern = Pattern.compile("[^0-9]+");
            Matcher matcher = pattern.matcher(goods.getUrl());
            skuId = matcher.replaceAll("").trim();
        }
        String commentStr = "";
        if (this.isPiderComment) {
            try {
                log.info("\u5546\u54c1\u7f16\u7801:" + skuId);
                this.getMent(comment, skuId);
                if (comment != null && comment.size() > 0) {
                    commentStr = JSONUtil.toJsonStr(comment);
                }
            }
            catch (Exception e) {
                log.error("\u8bc4\u4ef7\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            goods.setSupplierName(supplierName);
            goods.setSpuId(item1);
            goods.setSpuName(item2);
            goods.setSkuId(skuId);
            goods.setBrandName(brandName);
            goodsDetailsWithBLOBs.setSkuId(goods.getSkuId());
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{skuAttrNames, skuAttrJson})) {
                goodsDetailsWithBLOBs.setSkuSaleAttrNames(skuSaleAttrNames);
                goodsDetailsWithBLOBs.setSkuAttrNames(skuAttrNames);
                goodsDetailsWithBLOBs.setSkuAttrJson(skuAttrJson);
                goodsDetailsWithBLOBs.setComment(commentStr);
                log.info("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u6210\u529f{}", (Object)goods.getGoodsNo(), (Object)driver.getCurrentUrl());
            } else {
                log.info("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)driver.getCurrentUrl());
            }
            map.put("goods", goods);
            map.put("goodsDetails", goodsDetailsWithBLOBs);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7", (Throwable)e);
        }
    }

    private Html newHtml(RemoteWebDriver driver) {
        Html html = null;
        try {
            String rawText = driver.getPageSource();
            html = this.createHtml(rawText);
            if (html == null) {
                log.info("\u672a\u83b7\u53d6\u5230\u9875\u9762\u5143\u7d20{}", (Object)driver.getCurrentUrl());
            }
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e{}\u89e3\u6790\u5931\u8d25{}", (Object)driver.getCurrentUrl(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        return html;
    }

    private void getMent(HashMap<String, String> comment, String skuId) {
        String goodRateShow = "0";
        String commentCountStr = "0";
        String imageNum = "0";
        String videoCountStr = "0";
        String afterCountStr = "0";
        String goodCountStr = "0";
        String generalCountStr = "0";
        String poorCountStr = "0";
        try {
            String url = "https://api.m.jd.com/?functionId=pc_club_productCommentSummaries&body={\"referenceIds\":" + skuId + "}&area=14_1116_3431_57939&t=1748416861570&appid=item-v3";
            HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
            if (response.isOk()) {
                String result = response.body();
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject commentsummary;
                    JSONObject object = JSONObject.parseObject((String)result);
                    log.info("\u83b7\u53d6\u6570\u636eresult" + result);
                    JSONArray commentsArray = object.getJSONArray("CommentsCount");
                    log.info("\u83b7\u53d6\u6570\u636e" + commentsArray);
                    if (!commentsArray.isEmpty() && (commentsummary = commentsArray.getJSONObject(0)) != null) {
                        goodRateShow = commentsummary.getString("GoodRateShow");
                        commentCountStr = commentsummary.getString("CommentCountStr");
                        videoCountStr = commentsummary.getString("VideoCountStr");
                        afterCountStr = commentsummary.getString("AfterCountStr");
                        goodCountStr = commentsummary.getString("GoodCountStr");
                        generalCountStr = commentsummary.getString("GeneralCountStr");
                        poorCountStr = commentsummary.getString("PoorCountStr");
                        comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
                        comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                        comment.put("\u6652\u56fe", videoCountStr);
                        comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
                        comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
                        comment.put("\u597d\u8bc4\u6570", goodCountStr);
                        comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
                        comment.put("\u5dee\u8bc4\u6570", poorCountStr);
                    }
                }
            } else {
                log.info("\u8c03\u7528\u83b7\u53d6\u8bc4\u4ef7\u63a5\u53e3\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bc4\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    private int goodsComment(String goodNo, int page, HashMap<String, String> comment) {
        String result;
        String url = "https://api.m.jd.com/?appid=item-v3&functionId=pc_club_skuProductPageComments&client=pc&clientVersion=1.0.0&loginType=3&productId=" + goodNo + "&score=0&sortType=5&page=" + page + "&pageSize=10&isShadowSku=0&fold=1&bbtf=&shield=";
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
        int totalPage = 0;
        if (response.isOk() && StringUtils.isNotBlank((CharSequence)(result = response.body()))) {
            JSONArray list;
            JSONArray jsonObject;
            JSONObject object = JSONObject.parseObject((String)result);
            totalPage = object.getInteger("maxPage");
            int n = totalPage = totalPage > 100 ? 100 : totalPage;
            if (totalPage == 0) {
                return totalPage;
            }
            if (page == 0 && totalPage > 0) {
                String imageNum = object.getString("imageListCount");
                JSONObject commentsummary = object.getJSONObject("productCommentSummary");
                if (commentsummary != null) {
                    String goodRateShow = commentsummary.getString("goodRateShow");
                    String commentCountStr = commentsummary.getString("commentCountStr");
                    String videoCountStr = commentsummary.getString("videoCountStr");
                    String afterCountStr = commentsummary.getString("afterCountStr");
                    String goodCountStr = commentsummary.getString("goodCountStr");
                    String generalCountStr = commentsummary.getString("generalCountStr");
                    String poorCountStr = commentsummary.getString("poorCountStr");
                    comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
                    comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                    comment.put("\u6652\u56fe", imageNum);
                    comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
                    comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
                    comment.put("\u597d\u8bc4\u6570", goodCountStr);
                    comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
                    comment.put("\u5dee\u8bc4\u6570", poorCountStr);
                }
                Object commentTag = object.get((Object)"hotCommentTagStatistics");
                String statistics = "";
                if (commentTag != null) {
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    JSONArray list2 = JSONObject.parseArray((String)commentTag.toString(), (Feature[])new Feature[0]);
                    for (Map map : list2) {
                        map1.put(map.get("name").toString(), map.get("count").toString());
                    }
                    statistics = JSONUtil.toJsonStr(map1);
                } else {
                    statistics = "\u6682\u65e0\u4e70\u5bb6\u5370\u8c61";
                }
                comment.put("\u4e70\u5bb6\u5370\u8c61", statistics);
            }
            if ((jsonObject = object.getJSONArray("comments")) != null && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0])))) {
                ArrayList<GoodsCommentPO> goodsCommentPOS = new ArrayList<GoodsCommentPO>();
                for (Map map : list) {
                    GoodsCommentPO commentPO = new GoodsCommentPO();
                    commentPO.setPrefix(MallType.JD.getCode());
                    commentPO.setCreatetime(new Date());
                    commentPO.setUpdatetime(new Date());
                    if (map.get("nickname") != null) {
                        commentPO.setUserName(map.get("nickname").toString());
                    }
                    if (map.get("id") != null) {
                        commentPO.setCommentId(map.get("id").toString());
                    }
                    if (map.get("content") != null) {
                        commentPO.setCommentCon(map.get("content").toString());
                    }
                    if (map.get("creationTime") != null) {
                        commentPO.setCommentTime(map.get("creationTime").toString());
                    }
                    if (map.get("productColor") != null && map.get("productSize") != null) {
                        commentPO.setGoodAttr(map.get("productColor") + "  " + map.get("productSize"));
                    }
                    commentPO.setGoodsNo(goodNo);
                    if (map.get("location") != null) {
                        commentPO.setLocation(map.get("location").toString());
                    }
                    if (map.get("plusAvailable") != null) {
                        commentPO.setPlusAvailable(map.get("plusAvailable").toString());
                    }
                    if (map.get("replyCount") != null) {
                        commentPO.setSpriteComment(map.get("replyCount").toString());
                    }
                    if (map.get("topped") != null) {
                        commentPO.setSpritePraise(map.get("topped").toString());
                    }
                    if (map.get("score") != null) {
                        commentPO.setStar(map.get("score").toString());
                    }
                    goodsCommentPOS.add(commentPO);
                }
                this.executorService.submit(() -> this.processDataPipeline.processDataList(goodsCommentPOS));
            }
        }
        return totalPage;
    }

    private List<String> url(String skuId, String html) {
        String url = "https://api.m.jd.com/description/channel?appid=item-v3&functionId=pc_description_channel&client=pc&clientVersion=1.0.0&skuId=" + skuId;
        HttpResponse httpResponse = null;
        List<String> urlList = new ArrayList<String>();
        try {
            httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
            if (httpResponse != null && httpResponse.isOk()) {
                JSONObject jsonObject = JSONObject.parseObject((String)httpResponse.body());
                html = jsonObject.get((Object)"content").toString();
                urlList = JdDescriptionProcessorNewWithSelfDriver.extractLinks(html);
            } else {
                log.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25{}" + httpResponse.body());
            }
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
        }
        return urlList;
    }

    public static List<String> extractLinks(String html) {
        ArrayList<String> links = new ArrayList<String>();
        Pattern urlPattern = null;
        if (html != null) {
            String decodedHtml = html.replace("&quot;", "\"");
            urlPattern = html.contains("background-image:url") ? Pattern.compile("background-image:url\\(([^)]+)\\)", 2) : Pattern.compile("data-lazyload=[\"']([^\"]+)[\"']");
        }
        if (urlPattern != null) {
            Matcher matcher = urlPattern.matcher(html);
            while (matcher.find()) {
                String url = matcher.group(1).trim();
                if (url.startsWith("//")) {
                    url = "https:" + url;
                }
                String url1 = url.replace(".avif", "");
                log.info("\u8be6\u60c5\u56fe\u5730\u5740:" + url);
                links.add(url1);
            }
        }
        return links;
    }

    public static void main(String[] args) {
        String htmlContent = "{\"date\":1744284732483,\"content\":\"<p><a href=\\\"http://<img data-lazyload=\\\" img10.360buyimg.com=\\\"\\\" imgzone=\\\"\\\" jfs=\\\"\\\" t1=\\\"\\\" 183906=\\\"\\\" 35=\\\"\\\" 19733=\\\"\\\" 174046=\\\"\\\" 611c6e3bef2e43e9f=\\\"\\\" 8261b8cc81ac3427.jpg.avif\\\"=\\\"\\\" style=\\\"background-color: rgb(255, 255, 255);\\\"><img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/183906/35/19733/174046/611c6e3bEf2e43e9f/8261b8cc81ac3427.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/191311/18/18879/168959/611c6e3bE1047bbe9/71c28cda88e399c3.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/193306/8/18709/149507/611c6e3bEa0475d10/e84bb2a3032aba42.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/199106/24/3675/156554/611c6e3cE4c469b1a/834867907e6a57f8.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/199570/29/3596/84538/611c6e3cE10afdb4d/2cb54af3ea6d125a.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/177473/28/19678/104708/611c6e3cEd80c19d4/03427bf3cfe301d4.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/183684/19/19661/205963/611c6e3cEe9dc507f/5532dbdf6ed2fa3e.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/197893/4/3660/113256/611c6e3cEd4addfe8/5f7c2308ee97484e.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/206202/7/1793/143641/611c6e3cE1bc119e9/1e18f45b725e1208.jpg.avif\\\"> <img data-lazyload=\\\"//img10.360buyimg.com/imgzone/jfs/t1/183947/32/19790/85016/611c6e3cE5e8ad04c/971e6a3fca87c9c7.jpg.avif\\\">&nbsp;</a><img data-lazyload=\\\"http://img30.360buyimg.com/popWareDetail/jfs/t1/190546/20/18761/45075/611c70ecE019d4936/c7630d935eca0132.jpg.avif\\\" style=\\\"width: auto; height: auto; max-width: 100%;\\\"><br></p><p><br></p><br/>\"}";
        JSONObject jsonObject = JSONObject.parseObject((String)htmlContent);
        String html = jsonObject.get((Object)"content").toString();
        html = ".ssd-module-wrap{position:relative;margin:0 auto;width:750px;text-align:left;background-color:#fff}.ssd-module-wrap .ssd-module,.ssd-module-wrap .ssd-module-heading{width:750px;position:relative;overflow:hidden}.ssd-module-wrap .ssd-floor-activity{max-height:380px;overflow:hidden}.ssd-module-wrap .ssd-floor-shopPrior{max-height:900px;overflow:hidden}.ssd-module-wrap .ssd-floor-authorize{max-height:300px;overflow:hidden}.ssd-module-wrap .ssd-floor-reminder{max-height:4000px;overflow:hidden}.ssd-module-wrap .ssd-module{background-repeat:no-repeat;background-position:left top;background-size:100% 100%}.ssd-module-wrap .ssd-module-heading{background-repeat:no-repeat;background-position:left center;background-size:100% 100%}.ssd-module-wrap .ssd-module-heading .ssd-module-heading-layout{display:inline-block}.ssd-module-wrap .ssd-module-heading .ssd-widget-heading-ch{float:left;display:inline-block;margin:0 6px 0 15px;height:100%}.ssd-module-wrap .ssd-module-heading .ssd-widget-heading-en{float:left;display:inline-block;margin:0 15px 0 6px;height:100%}.ssd-module-wrap .ssd-widget-circle,.ssd-module-wrap .ssd-widget-line,.ssd-module-wrap .ssd-widget-pic,.ssd-module-wrap .ssd-widget-rectangle,.ssd-module-wrap .ssd-widget-table,.ssd-module-wrap .ssd-widget-text,.ssd-module-wrap .ssd-widget-triangle{position:absolute;overflow:hidden}.ssd-module-wrap .ssd-widget-rectangle{box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}.ssd-module-wrap .ssd-widget-triangle svg{width:100%;height:100%}.ssd-module-wrap .ssd-widget-table table{width:100%;height:100%}.ssd-module-wrap .ssd-widget-table td{position:relative;white-space:pre-line;word-break:break-all}.ssd-module-wrap .ssd-widget-pic img{display:block;width:100%;height:100%}.ssd-module-wrap .ssd-widget-text{line-height:1.5;word-break:break-all}.ssd-module-wrap .ssd-widget-text span{display:block;overflow:hidden;width:100%;height:100%;padding:0;margin:0;word-break:break-all;word-wrap:break-word;white-space:normal}.ssd-module-wrap .ssd-widget-link{position:absolute;left:0;top:0;width:100%;height:100%;background:0 0;z-index:100}.ssd-module-wrap .ssd-cell-text{position:absolute;top:0;left:0;right:0;width:100%;height:100%;overflow:auto}.ssd-module-wrap .ssd-show{display:block}.ssd-module-wrap .ssd-hide{display:none}.ssd-module-wrap .M16546052997441{width:750px; background-color:#d7d7d7; background-size:100% 100%; background-image:url(//img30.360buyimg.com/sku/jfs/t1/196999/39/24624/858934/629f45efE47f3615b/add28473c80b193b.jpg.avif); height:11752px}\n";
        List<String> urls = JdDescriptionProcessorNewWithSelfDriver.extractLinks(html);
        for (String url : urls) {
            System.out.println(url);
        }
    }

    public static String extractPathAfterHtml(String url, String lastIndex, String index) {
        int comIndex = url.lastIndexOf(lastIndex);
        if (comIndex == -1) {
            return "";
        }
        String afterCom = url.substring(comIndex + lastIndex.length());
        int htmlIndex = afterCom.indexOf(index);
        if (htmlIndex == -1) {
            return afterCom;
        }
        return afterCom.substring(0, htmlIndex);
    }
}

