/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Component
public class KlpDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(KlpDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        String url = goods.getUrl();
        try {
            String result = HttpRequest.post((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.info("\u79d1\u529b\u666e\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u79d1\u529b\u666e\u5546\u57ceurl{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String title;
        Html html = page.getHtml();
        String describePrice = html.$("div.product-param-right span em").xpath("///allText()").get();
        BigDecimal costPrice = new BigDecimal(0);
        if (describePrice != null) {
            String value = describePrice.replace("\u00a5", "");
            costPrice = new BigDecimal(value);
        }
        if (StringUtils.isNotEmpty((CharSequence)(title = html.$("div.product-title > h1").xpath("///allText()").get()))) {
            goods.setTitle(title);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder commodityAttribute = new StringBuilder();
        String paterUrl = page.getUrl().toString();
        StringBuilder url = new StringBuilder();
        url.append("https://www.colipu.com/ItemSku/GetAttributeGroupList?itemId=").append(ProcessRegexUtil.processKlpGoodsNo(paterUrl));
        HttpResponse response = HttpRequest.get((String)url.toString()).execute();
        String attributeList = new JsonPathSelector("$[*].AttributeList").select(response.body());
        String itemAtte = new JsonPathSelector("$[*].ItemAtte").select(response.body());
        if (!"null".equals(attributeList)) {
            List list = new JsonPathSelector("$[*].AttributeList.[*]").selectList(response.body());
            list.forEach(item -> {
                String attributeOuterName = new JsonPathSelector("$.AttributeOuterName").select(item);
                String attributeValue = new JsonPathSelector("$.AttributeValue").select(item);
                commodityAttribute.append(attributeOuterName).append(",");
                hashMap.put(attributeOuterName, attributeValue);
            });
        }
        if (itemAtte != null) {
            String brandName = new JsonPathSelector("$.BrandName").select(itemAtte);
            String color = new JsonPathSelector("$.Color").select(itemAtte);
            String modal = new JsonPathSelector("$.Modal").select(itemAtte);
            String specification = new JsonPathSelector("$.Specification").select(itemAtte);
            if (!"".equals(brandName)) {
                hashMap.put("\u54c1\u724c", brandName);
                commodityAttribute.append("\u54c1\u724c,");
            }
            if (!"".equals(color)) {
                hashMap.put("\u989c\u8272", color);
                commodityAttribute.append("\u989c\u8272,");
            }
            if (!"".equals(modal)) {
                hashMap.put("Modal", modal);
                commodityAttribute.append("Modal,");
            }
            if (!"".equals(specification)) {
                hashMap.put("\u89c4\u683c", specification);
                commodityAttribute.append("\u89c4\u683c,");
            }
        }
        String skuAttrJson = JSON.toJSONString(hashMap);
        String brandName = new JsonPathSelector("$[*].ItemAtte.BrandName").select(response.body());
        String skuId = html.$("div.product-number").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)skuId)) {
            String goodNo = skuId.replace("\u5546\u54c1\u7f16\u53f7\uff1a", "").trim();
            goods.setSkuId(goodNo);
        }
        StringBuilder textUrl = new StringBuilder();
        textUrl.append("https://www.colipu.com/ItemSku/GetItemText?itemId=").append(ProcessRegexUtil.processKlpGoodsNo(paterUrl));
        String introduce = html.$("div.product-body").get();
        goodsDetails.setPrefix(MallType.Klp.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
        goods.setPrefix(MallType.Klp.getCode());
        goods.setCostPrice(costPrice);
        goods.setPrice(costPrice);
        goods.setBrandName(brandName);
        if (costPrice.toString().equals("0")) {
            goods.setSkuState("0");
        }
    }

    public Site getSite() {
        return Site.me();
    }
}

