/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.json.JSONUtil;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.Html;

public class SnDescriptionProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(SnDescriptionProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 15;

    public static Map<String, Object> process(RemoteWebDriver driver, Goods paramTo) {
        String goodsNo = paramTo.getGoodsNo();
        String url = paramTo.getUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Goods goods = new Goods(MallType.Sn.getCode(), goodsNo);
        GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
        try {
            goodsDetailsWithBLOBs.setGoodsNo(goodsNo);
            goodsDetailsWithBLOBs.setPrefix(MallType.Sn.getCode());
            goods.setCategoryId(paramTo.getCategoryId());
            String[] strings = url.split("[/ : . \\- _ # %]");
            String skuId = strings[7];
            goods.setSkuId(skuId);
            driver.get(url);
            SnDescriptionProcessorWithSelfDriver.pageProcess(goodsDetailsWithBLOBs, goods, driver, url);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.info("\u82cf\u5b81\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            driver.quit();
            throw new DcBusinessException(e.getMessage());
        }
        log.info("\u82cf\u5b81\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetailsWithBLOBs);
        return map;
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private static void pageProcess(GoodsDetailsWithBLOBs goodsDetailsWithBLOBs, Goods goods, RemoteWebDriver driver, String url) {
        String branName;
        Html html = SnDescriptionProcessorWithSelfDriver.createHtml(driver.getPageSource());
        if (html.$("div.search404").match()) {
            goods.setSkuState("0");
            log.info("\u82cf\u5b81\u5546\u57ce\u7f16\u53f7{}\u6570\u636e{} \u5df2\u4e0b\u67b6", (Object)goods.getSkuId(), (Object)url);
            return;
        }
        try {
            WebElement element = driver.findElementById("productParTitle");
            element.click();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            log.error("\u4e0d\u5b58\u5728\u8be5\u5143\u7d20productParTitle");
        }
        long startTime = System.currentTimeMillis();
        html = SnDescriptionProcessorWithSelfDriver.createHtml(driver.getPageSource());
        String priceStr = html.$("span.mainprice").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)priceStr)) {
            if ((priceStr = priceStr.trim()).contains("-")) {
                String[] split = priceStr.split("-");
                priceStr = split[0].replace("\u00a5", "").trim();
            } else {
                priceStr = priceStr.replace("\u00a5", "").trim();
            }
        }
        String title = html.$("#itemDisplayName > li").xpath("///allText()").get();
        List nodes = html.$("div.tzm > dl.proattr-radio").nodes();
        String skuSaleAttrNames = "";
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            ArrayList saleAttrList = new ArrayList();
            nodes.forEach(node -> {
                String saleAttr = node.$("dt span").xpath("///allText()").get();
                if (StringUtils.isNotEmpty((CharSequence)saleAttr)) {
                    saleAttrList.add(saleAttr);
                }
            });
            skuSaleAttrNames = String.join((CharSequence)",", saleAttrList);
        }
        String introduce = html.$("div.prod-detail-container").get();
        String skuAttrNames = "";
        String skuAttrJson = "";
        ArrayList attrList = new ArrayList();
        HashMap jsonMap = new HashMap();
        List nodes1 = html.$("table.pro-para-tbl tbody > tr[parametercode]").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
            nodes1.forEach(node1 -> {
                String attr = node1.$("td.name div.name-inner span").xpath("///allText()").get();
                String attrValue = node1.$("td.val").xpath("///allText()").get();
                if (StringUtils.isEmpty((CharSequence)attr)) {
                    attr = node1.$("td.name").xpath("///allText()").get();
                }
                if (StringUtils.isNotEmpty((CharSequence)attr)) {
                    attrList.add(attr);
                    jsonMap.put(attr, attrValue);
                }
            });
            skuAttrNames = String.join((CharSequence)",", attrList);
            skuAttrJson = JSONUtil.toJsonStr(jsonMap);
        }
        if (StringUtils.isEmpty((CharSequence)(branName = (String)jsonMap.get("\u54c1\u724c")))) {
            branName = html.$("div.breadcrumb").xpath("///div[@role='menuitem']/span[@class='dropdown-text']/a/text()").get();
        }
        goods.setBrandName(branName);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)priceStr)) {
            goods.setPrice(new BigDecimal(priceStr));
        } else {
            goods.setSkuState("0");
        }
        if (StringUtils.isNotBlank((CharSequence)skuAttrJson)) {
            goodsDetailsWithBLOBs.setPrefix(MallType.Sn.getCode());
            goodsDetailsWithBLOBs.setSkuSaleAttrNames(skuSaleAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrNames(skuAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrJson(skuAttrJson);
            goodsDetailsWithBLOBs.setIntroduce(introduce);
            log.info("\u82cf\u5b81\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u6210\u529f", (Object)goods.getSkuId());
        }
    }
}

