/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class XfsDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(XfsDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String keyword = (String)request.getExtra("keyword");
        String url = goods.getUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            String[] strings = url.split("[/ : . \\- _ # %]");
            String skuId = strings[7];
            goods.setSkuId(skuId);
            String result = HttpRequest.post((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.info("\u53f2\u6cf0\u535a\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", keyword);
        log.info("xfs\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        Html html = page.getHtml();
        String brandName = html.$("span.skuBrand").xpath("///allText()").get();
        goods.setPrefix(MallType.Xfs.getCode());
        goods.setBrandName(brandName);
        goods.setUpdated(new Date());
        String skuAttrNames = "";
        String skuAttrJson = "";
        List nodes = html.$("div.aftersale_box div.standard > div").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            ArrayList attrNameList = new ArrayList();
            HashMap map = new HashMap();
            nodes.forEach(node -> {
                String attrName = node.xpath("span[1]").xpath("///allText()").get();
                String attrValue = node.xpath("span[2]").xpath("///allText()").get();
                if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{attrName, attrValue})) {
                    attrName = attrName.replace("\uff1a", "");
                    attrNameList.add(attrName);
                    map.put(attrName, attrValue);
                }
            });
            skuAttrNames = String.join((CharSequence)",", attrNameList);
            skuAttrJson = JSONUtil.toJsonStr(map);
        }
        String extJson = "";
        List nodes1 = html.$("div.proinfo_line > div.proinfo_tab").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
            HashMap map = new HashMap();
            nodes1.forEach(node -> {
                String attr = node.$("div.dt").xpath("///allText()").get();
                String attrValue = node.$("div.dd span").xpath("///allText()").get();
                if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{attr, attrValue})) {
                    String[] split = attr.split("\uff1a");
                    attr = split[0];
                    map.put(attr, attrValue);
                }
            });
            extJson = JSONUtil.toJsonStr(map);
        }
        String price = html.$("div.normal_price > span.yc-price > b").xpath("///allText()").get();
        String title = html.$("h1.skuname").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)price)) {
            String value = price.replace("\uffe5", "");
            goods.setPrice(new BigDecimal(value));
        }
        goodsDetails.setPrefix(MallType.Xfs.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuId(goods.getGoodsNo());
        goodsDetails.setSkuSaleAttrNames("");
        goodsDetails.setSkuAttrNames(skuAttrNames);
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setExtJson(extJson);
        goodsDetails.setCreated(new Date());
    }

    public Site getSite() {
        return Site.me();
    }
}

