/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceJDUtil;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class XyDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(XyDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String keyword = (String)request.getExtra("keyword");
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        String url = goods.getUrl();
        String skuId = ProcessRegexUtil.processXyGoodsNo(url);
        try {
            goods.setSkuId(skuId);
            HttpResponse httpResponse = HttpRequest.post((String)url).execute();
            if (httpResponse.getStatus() == 302) {
                RemoteWebDriver driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
                driver.get(url);
                Thread.sleep(200L);
                while (httpResponse.getStatus() == 302) {
                    CalcuLateDistanceJDUtil.ehsyDistance(driver);
                    httpResponse = HttpRequest.post((String)url).execute();
                }
                driver.quit();
            }
            String result = httpResponse.body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.info("\u897f\u57df\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", keyword);
        log.info("\u897f\u57df\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        Html html = page.getHtml();
        HashMap hashMap = new HashMap();
        List trs = html.$("tr.keyValue").nodes();
        StringBuilder commodityAttribute = new StringBuilder();
        trs.forEach(selectable -> {
            String goodsAttribute = selectable.$("td:nth-child(1)").xpath("///allText()").get();
            String goodsSaleAttribute = selectable.$("td:nth-child(2)").xpath("///allText()").get();
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        List divs = html.$("div.js-tabs-1").nodes();
        String introduce = null;
        if (divs.size() > 0) {
            introduce = ((Selectable)html.$("div.js-tabs-1").nodes().get(1)).toString();
        }
        List divList = html.$("div.attr-title").nodes();
        String brandName = "\u65e0";
        if (divList.size() > 2) {
            String s = ((Selectable)divList.get(1)).toString();
            brandName = ((Selectable)divList.get(1)).$("span:nth-child(3)").xpath("///allText()").get();
        } else {
            log.error("{}\u54c1\u724c\u4e3a\u7a7a", (Object)goods.getGoodsNo());
        }
        if (CollectionUtils.isEmpty((Collection)trs)) {
            log.info("{}\u7684\u5c5e\u6027\u4e3a\u7a7a", (Object)goods.getGoodsNo());
        }
        String price = html.$("span.show-price").xpath("///allText()").get();
        String title = html.$("div.product-info > div.product-info-detail > h1").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)price)) {
            String value = price.replace("\u00a5 ", "");
            goods.setPrice(new BigDecimal(value));
        } else {
            goods.setSkuState("0");
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
        goods.setPrefix(MallType.XiYu.getCode());
        goods.setBrandName(brandName);
        goodsDetails.setPrefix(MallType.XiYu.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
    }

    public Site getSite() {
        return Site.me();
    }
}

