/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class ZkhDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZkhDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String keyword = (String)request.getExtra("keyword");
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        String url = goods.getUrl();
        try {
            String result = HttpRequest.get((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Random random = new Random();
            TimeUnit.SECONDS.sleep(random.nextInt(10) + 1);
        }
        catch (Exception e) {
            log.info("zkh\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", keyword);
        log.info("zkh\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String paterUrl = page.getUrl().toString();
        Html html = page.getHtml();
        List div = html.$("ul.zkh-material-list div.zkh-prop-item").nodes();
        HashMap hashMap = new HashMap();
        StringBuilder commodityAttribute = new StringBuilder();
        div.forEach(selectable -> {
            String goodsAttribute = selectable.$("div.zkh-prop-tit").xpath("///allText()").get();
            String goodsSaleAttribute = selectable.$("div.zkh-prop-info", "title").get();
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        String brandName = html.css("div.params-row").$("span:nth-child(1)", "title").get();
        String introduce = html.$("div.params-wrap").get();
        String price = html.$("div.clearfix.zkh-prop-item.new-customer-discount-item > div.zkh-prop-info > span > b").xpath("///allText()").get();
        String[] strings = paterUrl.split("[/ : . \\- _ # %]");
        String skuId = strings[7];
        String title = html.$("div.zkh-prop-wrap > div > h1").xpath("///allText()").get();
        goodsDetails.setPrefix(MallType.ZKH.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
        goods.setPrefix(MallType.ZKH.getCode());
        goods.setBrandName(brandName);
        goods.setSkuId(skuId);
        if (StringUtils.isNotBlank((CharSequence)price)) {
            goods.setPrice(new BigDecimal(price));
        } else {
            goods.setSkuState("0");
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
        log.info("\u9707\u5764\u884c\u5546\u57ce:{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getGoodsNo());
    }

    public Site getSite() {
        return Site.me();
    }
}

