/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.exception.ChromeDriverException;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;
import us.codecraft.webmagic.selector.Selectable;

public class DlProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(DlProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 30;

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService, SelfDriver selfDriver) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        try {
            driver.get(url);
            TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
        }
        catch (Exception e) {
            driver.quit();
            log.error("DlProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
            throw new ChromeDriverException("DlProcessorWithSelfDriver : driver.get() is error");
        }
        String totalPageStr = null;
        long startTime = System.currentTimeMillis();
        while (StringUtils.isEmpty(totalPageStr)) {
            PageOperateUtil.pageRefresh(driver);
            Html html = DlProcessorWithSelfDriver.createHtml(driver.getPageSource());
            List nodes = html.$("ul.el-pager >li").nodes();
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                totalPageStr = ((Selectable)nodes.get(nodes.size() - 1)).xpath("///allText()").get();
            }
            if (TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime) <= 30L) continue;
            break;
        }
        ArrayList<Goods> goods = new ArrayList<Goods>();
        int totalPage = StringUtils.isNotEmpty(totalPageStr) ? Integer.parseInt(totalPageStr) : 1;
        log.info("\u5f97\u529b\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
        for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            JSONObject jsonObject = JSONObject.parseObject((String)"{\"sortName\":\"\",\"originalPriceEnd\":\"\",\"specList\":[],\"locateWh\":{\"hasStock\":\"\",\"regionCode\":\"1002\",\"cityCode\":\"14\",\"provinceCode\":\"10\"},\"locateProtocol\":{\"customerId\":\"\",\"hasProtocol\":\"\"},\"labels\":[],\"nowPage\":1,\"brandNameList\":[],\"backCategoryUuidList\":[],\"brandUuidList\":[],\"pageShow\":20,\"sortType\":\"\",\"totalNum\":0,\"keyword\":\"\",\"originalPriceStart\":\"\",\"frontCategoryUuid\":\"070ecc05e8b940b98f89985d62955e76\"}");
            jsonObject.put("nowPage", (Object)currentPage);
            jsonObject.put("frontCategoryUuid", (Object)categoryId);
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                jsonObject.put("keyword", (Object)keyword);
            }
            String targetUrl = "https://b2b.nbdeli.com/front/productlist/search";
            try {
                String rawText;
                HttpResponse response = HttpRequest.post((String)targetUrl).body(jsonObject.toString(), "application/json").execute();
                log.info("\u5f97\u529b\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)response.getStatus());
                if (response.isOk() && StringUtils.isNotEmpty((CharSequence)(rawText = response.body()))) {
                    DlProcessorWithSelfDriver.parsePage(rawText, goodsList, categoryId, categoryName);
                    if (CollectionUtils.isNotEmpty(goodsList)) {
                        int finalCurrentPage = currentPage;
                        executorService.submit(() -> processDataPipeline.processDataList(goodsList, finalCurrentPage, totalPage, keyword));
                    }
                    goods.addAll(goodsList);
                }
            }
            catch (Exception e) {
                log.info("DlProcessorWithSelfDriver process(): execute() is error", (Throwable)e);
            }
            paramTo.setGoods(goods);
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void parsePage(String rawText, List<Goods> goodsList, String categoryId, String categoryName) {
        JsonPathSelector jsonPathSelector = new JsonPathSelector("$.retData");
        String retData = jsonPathSelector.select(rawText);
        JsonPathSelector jsonPathSelector3 = new JsonPathSelector("$.skuList");
        List skuList = jsonPathSelector3.selectList(retData);
        JsonPathSelector productNameSelector = new JsonPathSelector("$.productName");
        JsonPathSelector skuNoSelector = new JsonPathSelector("$.skuNo");
        JsonPathSelector salePriceSelector = new JsonPathSelector("$.salePrice");
        JsonPathSelector bigPicSelector = new JsonPathSelector("$.bigPic");
        for (String sku : skuList) {
            try {
                String title = productNameSelector.select(sku);
                title = title.replaceAll("<[^<]*>", "");
                String skuNo = skuNoSelector.select(sku);
                String priceStr = salePriceSelector.select(sku);
                String pic = "";
                try {
                    if (sku.contains("bigPic")) {
                        pic = bigPicSelector.select(sku);
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u56fe\u7247\u5730\u5740\u5931\u8d25", (Throwable)e);
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.DL.getCode());
                goods.setGoodsNo(skuNo);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setTitle(title);
                goods.setPrice(StringUtils.isNotEmpty((CharSequence)priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setSkuId(skuNo);
                goods.setUrl("https://b2b.nbdeli.com/pcweb/detail?sku=" + skuNo);
                goods.setPic("https://img.jslink.com/" + pic);
                goods.setCreated(new Date());
                goodsList.add(goods);
            }
            catch (Exception e) {
                log.info("DlProcessorWithSelfDriver parsePage() : select() is error", (Throwable)e);
            }
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

