/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class GajProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(GajProcessor.class);
    @Resource
    private ProcessDataPipeline processDataPipeline;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void process(Page page) {
        String paterUrl = page.getUrl().toString();
        HashMap map = new HashMap();
        ArrayList<Goods> goodsLists = new ArrayList<Goods>();
        Html html = page.getHtml();
        String bottom = html.$("div.total").xpath("///allText()").get();
        String pageTotalStr = null;
        String data = null;
        if (bottom != null) {
            pageTotalStr = ProcessRegexUtil.processGajTotalPage(bottom);
            data = ProcessRegexUtil.processGajDataNumber(bottom);
        }
        int totalPage = 0;
        if (pageTotalStr != null) {
            totalPage = Integer.parseInt(pageTotalStr);
        } else {
            log.info("\u603b\u9875\u6570\u4e3a0");
        }
        int dataSize = 0;
        if (data != null) {
            dataSize = Integer.parseInt(data);
        } else {
            log.info("\u6bcf\u9875\u6570\u636e\u4e3a0");
        }
        int currentPage = 2;
        log.info("\u56fa\u5b89\u6377\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)totalPage);
        this.pageProcess(page, goodsLists, dataSize, 1, totalPage);
        for (int i = 2; i <= totalPage; ++i) {
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            String categoryId = ProcessRegexUtil.extractNumbers(paterUrl);
            StringBuilder url = new StringBuilder();
            url.append("https://www.mymro.cn/c-").append(categoryId).append(".html?sort=all&pageNo=").append(currentPage).append("&pageTrigger=true&sort=all");
            String result = HttpRequest.get((String)url.toString()).execute().body();
            Page page1 = PageOperateUtil.createPage(url.toString(), result);
            log.info("\u5f53\u524d\u9875\u4e3a{}\u9875", (Object)currentPage);
            this.pageProcess(page1, goodsList, dataSize, currentPage, totalPage);
            ++currentPage;
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void pageProcess(Page page, List<Goods> goodsLists, int dataSize, int currentPage, int totalPage) {
        Html html = page.getHtml();
        String paterUrl = page.getUrl().toString();
        String categoryId = ProcessRegexUtil.extractNumbers(paterUrl);
        List lis = html.$("div.right_detail").nodes();
        if (lis.size() != dataSize) {
            log.info("\u7b2c{}\u9875\u6570\u636e\u4e0d\u6b63\u5e38", (Object)currentPage);
        } else {
            log.info("\u7b2c{}\u9875\u6570\u636e\u6b63\u5e38", (Object)currentPage);
        }
        lis.forEach(item -> {
            String name = item.$("div.table_title span").xpath("///allText()").get();
            String img = item.$("div.image_info img").xpath("///@src").get();
            List trs = item.$("div.table_con tbody>tr").nodes();
            trs.forEach(tr -> {
                String goodsNo;
                String link = tr.$("td.itemCode").$("a", "href").get();
                String integer = tr.xpath("//span[@class='price-integer']/text()").get();
                String decimal = tr.$("span.price-decimal").xpath("///allText()").get();
                StringBuilder url = new StringBuilder();
                url.append("https://www.mymro.cn").append(link);
                BigDecimal price = new BigDecimal(0);
                integer = ProcessRegexUtil.extractNumbers(integer);
                if (integer != null || decimal != null) {
                    StringBuilder money = new StringBuilder();
                    money.append(integer).append(".").append(decimal);
                    price = new BigDecimal(money.toString());
                }
                if ((goodsNo = ProcessRegexUtil.processGajGoodsNo(link)) == null) {
                    log.info("{}\u5206\u7c7b\u4e0b{}\u7684goodsNo\u4e3anull", (Object)categoryId, (Object)name);
                }
                Goods article = new Goods();
                article.setPrefix(MallType.GAJ.getCode());
                article.setGoodsNo(goodsNo);
                article.setSkuId(goodsNo);
                article.setTitle(name);
                article.setPrice(price);
                article.setPic(img);
                article.setUrl(url.toString());
                article.setCategoryId(categoryId);
                article.setCreated(new Date());
                goodsLists.add(article);
            });
        });
        executorService.submit(() -> this.processDataPipeline.processDataList(goodsLists, currentPage, totalPage, null));
    }

    public Site getSite() {
        return Site.me();
    }
}

