/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GomeProcessor {
    private static final Logger log = LoggerFactory.getLogger(GomeProcessor.class);

    public static void processor(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService) {
        ArrayList<Goods> goodsL = new ArrayList<Goods>();
        int page = 1;
        int total = GomeProcessor.processorPage(paramTo, processDataPipeline, goodsL, page);
        if (total > 1) {
            for (int i = 1; i < total; ++i) {
                ++page;
                try {
                    Thread.sleep(200L);
                    GomeProcessor.processorPage(paramTo, processDataPipeline, goodsL, page);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u56fd\u7f8e\u5546\u57ce\u5206\u7c7b{}\u8bf7\u6c42\u5931\u8d25,\u5f53\u524d\u9875{}", new Object[]{paramTo.getCategoryId(), page, e});
                }
            }
        }
    }

    private static int processorPage(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, List<Goods> goodsL, int page) {
        String url = paramTo.getUrl();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        int totalPage = 0;
        try {
            String result;
            HttpResponse httpResponse;
            url = url + "?page=" + page + "&bws=0&type=json&rank=1";
            if (keyword != null) {
                url = url + "&question=" + keyword + "";
            }
            if ((httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute()).isOk() && (result = httpResponse.body()) != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                JSONObject content = object.getJSONObject("content");
                JSONObject pageBar = content.getJSONObject("pageBar");
                totalPage = pageBar.getInteger("totalPage");
                int totalCount = pageBar.getInteger("totalCount");
                if (totalCount > 0) {
                    JSONObject prodInfo = content.getJSONObject("prodInfo");
                    JSONArray jsonObject = prodInfo.getJSONArray("products");
                    if (jsonObject != null) {
                        JSONArray list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0]);
                        ArrayList<Goods> goodsList = new ArrayList<Goods>();
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            for (Map map : list) {
                                Goods goods = new Goods();
                                String saleOrgId = map.get("saleOrgId").toString();
                                String shopId = map.get("shopId").toString();
                                String pId = map.get("pId").toString();
                                String skuId = map.get("skuId").toString();
                                String skuNo = map.get("skuNo").toString();
                                goods.setGoodsNo(skuId);
                                goods.setPrefix(MallType.Gome.getCode());
                                goods.setSkuId(skuNo);
                                goods.setSpuId(pId);
                                goods.setUrl("https:" + map.get("sUrl"));
                                goods.setTitle(map.get("alt").toString());
                                goods.setPic("https:" + map.get("sImg"));
                                goods.setPrice(GomeProcessor.processPrice(saleOrgId, shopId, pId, skuId));
                                goods.setCategoryId(map.get("defCatId").toString());
                                goods.setCategoryName(categoryName);
                                goods.setSkuState("1");
                                goodsList.add(goods);
                            }
                            log.info("\u5f53\u524d\u603b\u5171{}\u9875,\u5f53\u524d\u7b2c{}\u9875", (Object)totalPage, (Object)page);
                            processDataPipeline.processDataList(goodsList, page, totalPage, keyword);
                            goodsL.addAll(goodsList);
                            paramTo.setGoods(goodsL);
                        } else {
                            log.info("\u56fd\u7f8e\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                        }
                    } else {
                        log.info("\u56fd\u7f8e\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                    }
                } else {
                    log.info("\u56fd\u7f8e\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                }
            }
        }
        catch (Exception e) {
            log.error("\u56fd\u7f8e\u5546\u57ce\u722c\u53d6\u5546\u54c1\u5217\u8868\u5931\u8d25{}", (Object)url, (Object)e);
        }
        return totalPage;
    }

    private static BigDecimal processPrice(String saleOrgId, String shopId, String pId, String skuId) {
        JSONObject object;
        String result;
        if (StringUtils.isEmpty((String)saleOrgId)) {
            saleOrgId = "null";
        }
        BigDecimal price = new BigDecimal(0);
        String url = "https://ss.gome.com.cn/search/v1/price/single/" + saleOrgId + "/" + shopId + "/" + pId + "/" + skuId + "/11010000/flag/item";
        HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
        if (httpResponse.isOk() && (result = httpResponse.body()) != null && (object = JSONObject.parseObject((String)result)).get((Object)"success").toString().equals("true")) {
            JSONObject object1 = object.getJSONObject("result");
            price = new BigDecimal(object1.get((Object)"price").toString());
        }
        return price;
    }
}

