/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.exception.ChromeDriverException;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class JdProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdProcessorWithSelfDriver.class);
    private static SpiderService spiderService;
    private static boolean enable;
    private static String cookie;
    public static final int MAX_OUT_TIME = 60;

    @Value(value="${nicc-plugin.spider.jdcookie}")
    public void setCookie(String cookie) {
        JdProcessorWithSelfDriver.cookie = cookie;
    }

    @Autowired
    public void setSpiderService(SpiderService spiderService) {
        JdProcessorWithSelfDriver.spiderService = spiderService;
    }

    @Value(value="${aliyun.spider.enable}")
    public void setEnable(boolean enable) {
        JdProcessorWithSelfDriver.enable = enable;
    }

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, SelfDriver selfDriver) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        Random random = new Random();
        ArrayList<Goods> goods = new ArrayList<Goods>();
        try {
            Html html;
            driver = JdProcessorWithSelfDriver.loginCookie(driver);
            TimeUnit.SECONDS.sleep(1L);
            driver.navigate().refresh();
            driver.get(url);
            TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
            String currentUrl = driver.getCurrentUrl();
            if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://passport.jd.com/")) {
                return;
            }
            if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://www.jd.com/?from") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"lgid=2193") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://cfe.m.jd.com")) {
                log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e\u88ab\u62e6\u622a,URL\u4e3a{},\u6d4f\u89c8\u5668\u5730\u5740\u4e3a{}", (Object)url, (Object)currentUrl);
                if (enable) {
                    log.info("\u66f4\u6362ip", (Object)categoryId);
                    spiderService.changeIP();
                } else {
                    TimeUnit.SECONDS.sleep(3600L);
                }
            }
            if ((html = JdProcessorWithSelfDriver.newHtml(url, 1, driver)) != null) {
                String totalPageStr = html.$("div#J_bottomPage span.p-skip em b").xpath("///allText()").get();
                if (StringUtils.isEmpty((CharSequence)totalPageStr)) {
                    totalPageStr = html.$("div#J_topPage span.fp-text i").xpath("///allText()").get();
                }
                if (StringUtils.isEmpty((CharSequence)totalPageStr)) {
                    return;
                }
                int totalPage = totalPageStr != null ? Integer.parseInt(totalPageStr) : 0;
                log.info("\u4eac\u4e1c\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                    html = JdProcessorWithSelfDriver.newHtml(url, currentPage, driver);
                    try {
                        if (html == null) {
                            return;
                        }
                        Thread.sleep(random.nextInt(1000));
                        ArrayList<Goods> goodsList = new ArrayList<Goods>();
                        JdProcessorWithSelfDriver.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, driver, url);
                        if (CollectionUtils.isNotEmpty(goodsList)) {
                            processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                            log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
                            goods.addAll(goodsList);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u89e3\u6790\uff1a{}\u9875\u9762\u5931\u8d25error{}", (Object)currentPage, (Object)e);
                    }
                    if (currentPage != totalPage) {
                        currentUrl = driver.getCurrentUrl();
                        if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://cfe.m.jd.com") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://www.jd.com/?from") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://passport.jd.com/")) continue;
                        try {
                            WebElement next = driver.findElementByClassName("pn-next");
                            if (next == null) {
                                next = driver.findElementByClassName("fp-next");
                            }
                            next.sendKeys(new CharSequence[]{Keys.ENTER});
                        }
                        catch (Exception e) {
                            log.error("JdProcessorWithSelfDriver : next.sendKeys(Keys.ENTER); is error");
                        }
                        continue;
                    }
                    break;
                }
            } else {
                log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b{}\u6570\u636e\u89e3\u6790\u5931\u8d25", (Object)categoryId);
                if (enable) {
                    log.info("\u66f4\u6362ip", (Object)categoryId);
                    spiderService.changeIP();
                } else {
                    TimeUnit.SECONDS.sleep(3600L);
                }
            }
            paramTo.setGoods(goods);
        }
        catch (Exception e) {
            log.info("JdProcessorWithSelfDriver : driver.get() is error");
            driver.quit();
            throw new ChromeDriverException("JdProcessorWithSelfDriver : driver.get() is error");
        }
    }

    private static void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, RemoteWebDriver driver, String url) {
        List nodes = html.$("ul.gl-warp.clearfix > li").nodes();
        if (nodes == null) {
            return;
        }
        if (currentPage == totalPage) {
            if (nodes.size() == 0) {
                html = JdProcessorWithSelfDriver.newHtml(url, currentPage, driver);
                nodes = html.$("ul.gl-warp.clearfix > li").nodes();
            }
        } else if (nodes.size() < 60) {
            html = JdProcessorWithSelfDriver.newHtml(url, currentPage, driver);
            nodes = html.$("ul.gl-warp.clearfix > li").nodes();
        }
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            for (Selectable node : nodes) {
                String sku = node.$("li").xpath("///@data-sku").get();
                String href = "https://item.jd.com/" + sku + ".html";
                String title = node.$("li").$("div.p-name em").xpath("///allText()").get();
                String priceStr = node.$("li").$("div.p-price i").xpath("///allText()").get();
                String pic = "https:" + node.$("div.p-img > a > img").xpath("///@src").get();
                if (StringUtils.isEmpty((CharSequence)sku)) {
                    sku = node.$("li div.gl-i-wrap").xpath("///@data-sku").get();
                }
                if (!StringUtils.isNotBlank((CharSequence)sku)) continue;
                Goods goods = new Goods();
                goods.setPrefix(MallType.JD.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setUrl(href);
                goods.setTitle(StringUtils.isNotBlank((CharSequence)title) ? title : "");
                goods.setPic(StringUtils.isNotBlank((CharSequence)pic) ? pic : null);
                goods.setPrice(StringUtils.isNotBlank((CharSequence)priceStr) && ProcessRegexUtil.processJdPrice(priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goodsList.add(goods);
            }
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private static Html newHtml(String url, int currentPage, RemoteWebDriver driver) {
        Html html = null;
        int page = (currentPage - 1) * 2 + 1;
        int s = (currentPage - 1) * 60 + 1;
        url = url + "&page=" + page + "&s=" + s + "&click=0";
        try {
            for (int num = 1; html == null && num <= 3; ++num) {
                String currentUrl = driver.getCurrentUrl();
                if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://cfe.m.jd.com")) {
                    HttpResponse httpResponse = HttpRequest.get((String)url).execute();
                    if (httpResponse.isOk()) {
                        String result = httpResponse.body();
                        html = JdProcessorWithSelfDriver.createHtml(result);
                    }
                    log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e\u88ab\u62e6\u622a,URL\u4e3a{},\u6d4f\u89c8\u5668\u5730\u5740\u4e3a{}", (Object)url, (Object)currentUrl);
                    continue;
                }
                PageOperateUtil.pageRefresh(driver);
                String rawText = driver.getPageSource();
                html = JdProcessorWithSelfDriver.createHtml(rawText);
            }
            if (html == null) {
                log.info("\u672a\u83b7\u53d6\u5230\u9875\u9762\u5143\u7d20{}", (Object)driver.getCurrentUrl());
            }
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e{}\u89e3\u6790\u5931\u8d25{}", (Object)driver.getCurrentUrl(), (Object)e);
        }
        return html;
    }

    private static RemoteWebDriver loginCookie(RemoteWebDriver driver) {
        driver.get("https://jd.com/");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse("2040-12-31 18:00:00");
            if (StringUtils.isNotEmpty((CharSequence)cookie)) {
                Cookie cookie1 = new Cookie(StringUtils.substringBefore((String)cookie, (String)"=").trim(), StringUtils.substringAfter((String)cookie, (String)"=").trim(), ".jd.com", null, date, true, true);
                driver.manage().addCookie(cookie1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return driver;
    }
}

