/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.json.JSONUtil;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceJDUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.SpiderShopUserMapper;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.mapper.po.SpiderShopUser;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class JdSearchProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdSearchProcessorWithSelfDriver.class);
    @Autowired
    private SpiderShopUserMapper spiderShopUserMapper;

    public boolean process(GoodsBO goodsBO, String url, ProcessDataPipeline processDataPipeline, SelfDriver selfDriver) {
        String keyword = goodsBO.getTitle();
        RemoteWebDriver driver = selfDriver.getDriver();
        Random random = new Random();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        boolean flag = false;
        try {
            TimeUnit.SECONDS.sleep(1L);
            driver.navigate().refresh();
            driver.get(url);
            TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(5, 10));
            String currentUrl = driver.getCurrentUrl();
            if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://passport.jd.com/") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://www.jd.com/?from")) {
                log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e\u88ab\u62e6\u622a,URL\u4e3a{},\u6d4f\u89c8\u5668\u5730\u5740\u4e3a{}", (Object)url, (Object)currentUrl);
                SpiderShopUser user = new SpiderShopUser();
                user.setCookie(goodsBO.getCookie());
                user.setGoodsUserd(Integer.valueOf(0));
                this.spiderShopUserMapper.updateByCookie(user);
                throw new DcBusinessException("\u4eac\u4e1c\u5546\u57ce\u6570\u636e\u88ab\u62e6\u622a,\u6d4f\u89c8\u5668\u5730\u5740\u4e3a:" + currentUrl);
            }
            if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://cfe.m.jd.com")) {
                TimeUnit.SECONDS.sleep(3L);
                WebElement next = driver.findElementByClassName("verifyBtn");
                next.click();
                TimeUnit.SECONDS.sleep(1L);
                String html = driver.getPageSource();
                int num = 1;
                while (html.contains("small_img")) {
                    CalcuLateDistanceJDUtil.calcuLateDistance(driver);
                    TimeUnit.SECONDS.sleep(1L);
                    if (num > 5) break;
                    ++num;
                }
            }
            Html html = JdSearchProcessorWithSelfDriver.createHtml(driver.getPageSource());
            try {
                if (html == null) {
                    return false;
                }
                Thread.sleep(random.nextInt(1000));
                flag = this.pageProcess(html, goodsList, goodsDetailsList, goodsBO);
                if (CollectionUtils.isNotEmpty(goodsList)) {
                    map.put("goodsList", goodsList);
                    map.put("goodsDetailsList", goodsDetailsList);
                    map.put("keyword", keyword);
                    processDataPipeline.processDataMap(map);
                    log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u9875\u89e3\u6790\u6210\u529f");
                }
            }
            catch (Exception e) {
                log.error("\u5206\u9875\u89e3\u6790\uff1a{}\u9875\u9762\u5931\u8d25error{}", (Object)1, (Object)e);
            }
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u641c\u7d22\u722c\u53d6\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        return flag;
    }

    private boolean pageProcess(Html html, List<Goods> goodsList, List<GoodsDetailsWithBLOBs> goodsDetailsList, GoodsBO goodsBO) {
        List nodes = html.$("ul.gl-warp.clearfix > li").nodes();
        if (nodes == null) {
            return false;
        }
        boolean flag = false;
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            for (Selectable node : nodes) {
                String sku = node.$("li").xpath("///@data-sku").get();
                String href = "https://item.jd.com/" + sku + ".html";
                String title = node.$("li").$("div.p-name em").xpath("///allText()").get();
                String priceStr = node.$("li").$("div.p-price i").xpath("///allText()").get();
                String pic = "https:" + node.$("div.p-img > a > img").xpath("///@src").get();
                if (StringUtils.isEmpty((CharSequence)sku)) {
                    sku = node.$("li div.gl-i-wrap").xpath("///@data-sku").get();
                }
                HashMap<String, String> comment = new HashMap<String, String>();
                String commentStr = "";
                try {
                    String commentCountStr = node.$("#J_comment_" + sku).xpath("///allText()").get().replace("+", "");
                    if (StringUtils.isNotEmpty((CharSequence)commentCountStr)) {
                        comment.put("\u597d\u8bc4\u5ea6", "");
                        comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                        comment.put("\u6652\u56fe", "");
                        comment.put("\u89c6\u9891\u6652\u5355\u6570", "");
                        comment.put("\u8ffd\u8bc4\u6570", "");
                        comment.put("\u597d\u8bc4\u6570", "");
                        comment.put("\u4e2d\u8bc4\u6570", "");
                        comment.put("\u5dee\u8bc4\u6570", "");
                        commentStr = JSONUtil.toJsonStr(comment);
                    }
                }
                catch (Exception e) {
                    log.error("\u672a\u83b7\u53d6\u5230\u8bc4\u4ef7");
                }
                if (!StringUtils.isNotBlank((CharSequence)sku)) continue;
                Goods goods = new Goods();
                if (sku.equals(goodsBO.getSkuId())) {
                    flag = true;
                    goods.setGoodsNo(goodsBO.getGoodsNo());
                } else {
                    goods.setGoodsNo(sku);
                }
                goods.setPrefix(MallType.JD.getCode());
                goods.setSkuId(sku);
                goods.setUrl(href);
                goods.setTitle(StringUtils.isNotBlank((CharSequence)title) ? title : "");
                goods.setPic(StringUtils.isNotBlank((CharSequence)pic) ? pic : null);
                goods.setPrice(StringUtils.isNotBlank((CharSequence)priceStr) && ProcessRegexUtil.processJdPrice(priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setCategoryId("0");
                goodsList.add(goods);
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
                goodsDetailsWithBLOBs.setGoodsNo(goods.getGoodsNo());
                goodsDetailsWithBLOBs.setPrefix(MallType.JD.getCode());
                goodsDetailsWithBLOBs.setSkuId(goods.getSkuId());
                goodsDetailsWithBLOBs.setSkuSaleAttrNames("");
                goodsDetailsWithBLOBs.setSkuAttrNames("");
                goodsDetailsWithBLOBs.setSkuAttrJson("");
                goodsDetailsWithBLOBs.setComment(commentStr);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
        }
        return flag;
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

