/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.exception.ChromeDriverException;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

public class SnProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(SnProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 100;

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService, SelfDriver selfDriver) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        try {
            driver.get(url);
            Thread.sleep(500L);
        }
        catch (Exception e) {
            log.error("SnProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
            driver.quit();
            throw new ChromeDriverException("SnProcessorWithSelfDriver : driver.get() is error");
        }
        PageOperateUtil.pageRefresh(driver);
        Html html = SnProcessorWithSelfDriver.createHtml(driver.getPageSource());
        ArrayList<Goods> goods = new ArrayList<Goods>();
        Selectable selectable = html.$("span.fl");
        if (!Objects.isNull(selectable)) {
            String totalPageStr1 = selectable.xpath("///allText()").get();
            if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                String totalPageStr2 = totalPageStr1.replaceAll(" ", "").split("/")[1];
                int totalPage = Integer.parseInt(totalPageStr2);
                log.info("\u82cf\u5b81\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                    PageOperateUtil.pageRefresh(driver);
                    html = SnProcessorWithSelfDriver.createHtml(driver.getPageSource());
                    ArrayList<Goods> goodsList = new ArrayList<Goods>();
                    SnProcessorWithSelfDriver.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, selfDriver);
                    int finalCurrentPage = currentPage;
                    String finalKeyword = keyword;
                    executorService.submit(() -> processDataPipeline.processDataList(goodsList, finalCurrentPage, totalPage, finalKeyword));
                    if (currentPage == totalPage) break;
                    try {
                        WebElement next = driver.findElementById("nextPage");
                        next.sendKeys(new CharSequence[]{Keys.ENTER});
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        log.error("SnProcessorWithSelfDriver : next.sendKeys(Keys.ENTER); is error");
                        break;
                    }
                    goods.addAll(goodsList);
                }
            } else {
                log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", (Object)totalPageStr1);
            }
            paramTo.setGoods(goods);
        } else {
            log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
        }
    }

    private static void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, SelfDriver selfDriver) {
        RemoteWebDriver driver = selfDriver.getDriver();
        List nodes = html.$("div.product-list.clearfix ul.general.clearfix > li").nodes();
        long startTime = System.currentTimeMillis();
        for (int num = 1; num <= 3; ++num) {
            if (currentPage != totalPage) {
                if (nodes.size() >= 120) break;
                PageOperateUtil.pageRefresh(driver);
                html = SnProcessorWithSelfDriver.createHtml(driver.getPageSource());
                nodes = html.$("div.item-bg").nodes();
                continue;
            }
            PageOperateUtil.pageRefresh(driver);
            html = SnProcessorWithSelfDriver.createHtml(driver.getPageSource());
            nodes = html.$("div.item-bg").nodes();
            if (nodes.size() > 0) break;
        }
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String skuStr;
                String[] split;
                String sku;
                String title = node.$("div.res-info div.title-selling-point a").xpath("///allText()").get();
                String href = node.$("div.res-info div.title-selling-point a").xpath("///@href").get();
                String price = node.$("div.price-box").xpath("///allText()").get();
                if (price == null) {
                    price = node.$("em.prive price").xpath("///allText()").get();
                }
                BigDecimal price1 = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)price)) {
                    price = ProcessRegexUtil.extractNumbers(price);
                    price1 = new BigDecimal(price);
                }
                if (StringUtils.isNotBlank((CharSequence)href) && !href.startsWith("http")) {
                    href = "https:" + href;
                }
                if ((sku = (split = href.split("/"))[split.length - 1].replace(".html", "").trim()).length() > 100 && (sku = (skuStr = ProcessRegexUtil.processSnSku(sku)).replace("&", "").replace("cmdCode=", "").trim()).length() > 100) {
                    sku = null;
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.Sn.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setTitle(title);
                goods.setPrice(price1);
                goods.setUrl(href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goodsList.add(goods);
            }
            log.info("\u82cf\u5b81\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
        } else {
            log.info("\u82cf\u5b81\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

