/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.StbDescriptionProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class StbProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(StbProcessor.class);
    private RemoteWebDriver driver;
    @Resource
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private StbDescriptionProcessor stbDescriptionProcessor;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void process(Page page) {
        this.driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
        try {
            Request request = page.getRequest();
            String keyword = (String)request.getExtra("keyword");
            HashMap map = new HashMap();
            String paterUrl = page.getUrl().toString();
            ArrayList<Goods> goodsLists = new ArrayList<Goods>();
            this.driver.get(paterUrl);
            PageOperateUtil.pageRefresh(this.driver);
            Page page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
            this.pageProcess(page0, goodsLists, keyword);
            Html html = page0.getHtml();
            String totalPage = html.xpath("//span[@class='total ng-binding']/text()").toString();
            String total = "0";
            if (totalPage != null) {
                Pattern pattern = Pattern.compile("[^0-9]+");
                Matcher matcher = pattern.matcher(totalPage);
                total = matcher.replaceAll("").trim();
            } else {
                log.info("{}\u4e0b\u6ca1\u6709\u6570\u636e", (Object)paterUrl);
            }
            int maxSize = Integer.parseInt(total);
            log.info("\u53f2\u6cf0\u535a\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)maxSize);
            executorService.submit(() -> this.processDataPipeline.processDataList(goodsLists, 1, maxSize, keyword));
            int i = 2;
            while (i <= maxSize) {
                ArrayList<Goods> goodsList2 = new ArrayList<Goods>();
                try {
                    WebElement next = this.driver.findElementByXPath("//div[@class='search-pag']/a[last()-1]");
                    next.sendKeys(new CharSequence[]{Keys.ENTER});
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    break;
                }
                PageOperateUtil.pageRefresh(this.driver);
                Page page1 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                log.info("\u5f53\u524d\u4e3a\u7b2c{}\u9875", (Object)i);
                this.pageProcess(page1, goodsList2, keyword);
                int finalI = i++;
                executorService.submit(() -> this.processDataPipeline.processDataList(goodsList2, finalI, maxSize, keyword));
                log.info("\u53f2\u6cf0\u535a\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6709{}\u6761\u6570\u636e", (Object)goodsList2.size());
            }
        }
        catch (Exception e) {
            log.error("\u53f2\u6cf0\u535a\u5546\u57ce\u6b64\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            this.driver.quit();
        }
        this.driver.quit();
    }

    public void pageProcess(Page page, List<Goods> goodsLists, String keyword) {
        Html html = page.getHtml();
        String paterUrl = page.getUrl().toString();
        List product = html.$("div.goods-content").nodes();
        product.forEach(item -> {
            String link = item.$("a", "href").get();
            String img = item.$("img").xpath("///@src").get();
            String money = item.$("div.price span").xpath("///allText()").get();
            BigDecimal price = new BigDecimal(0);
            if (money != null) {
                String cash = money.replace("\uffe5", "");
                String belongings = cash.replace(",", "");
                price = new BigDecimal(belongings);
            }
            String name = item.$("h5 span").xpath("///allText()").get();
            StringBuilder url = new StringBuilder();
            if (!link.contains("http://www.stbcn.com")) {
                url.append("http://www.stbcn.com").append(link);
            } else {
                url.append(link);
            }
            StringBuilder image = new StringBuilder();
            image.append("https:").append(img);
            if (log.isDebugEnabled()) {
                log.debug("url\u4e3a{},image\u4e3a{},money\u4e3a{}", new Object[]{url, image, price});
            }
            String categoryId = null;
            if (StringUtils.isEmpty((CharSequence)keyword)) {
                String[] strings = paterUrl.split("[/ : . \\- _ # % & = ?]");
                categoryId = strings[9];
            }
            String goodsNo = item.$("p.pdB5").xpath("///allText()").get().replace("\u5546\u54c1\u7f16\u7801\uff1a", "");
            Goods article = new Goods();
            article.setPrefix(MallType.Stb.getCode());
            article.setGoodsNo(goodsNo);
            article.setSkuId(goodsNo);
            article.setTitle(name);
            article.setPrice(price);
            article.setPic(image.toString());
            article.setUrl(url.toString());
            article.setCategoryId(categoryId);
            article.setCreated(new Date());
            goodsLists.add(article);
            if (log.isDebugEnabled()) {
                log.debug("\u53f2\u6cf0\u535a\u5546\u57ce{}\u4e0b\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)categoryId, (Object)article);
            }
        });
        if (keyword != null && CollectionUtils.isNotEmpty(goodsLists)) {
            HashMap hashMap = new HashMap();
            Request request = new Request();
            executorService.submit(() -> this.spiderDetail(hashMap, request, goodsLists, keyword));
        }
    }

    public Site getSite() {
        return Site.me().addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36").addHeader("Upgrade-Insecure-Requests", "1").addHeader("Sec-Fetch-Mode", "navigate");
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.stbDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

