/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.ZkhDescriptionProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceUtil;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class ZkhProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZkhProcessor.class);
    private RemoteWebDriver driver;
    @Resource
    private ZkhDescriptionProcessor zkhDescriptionProcessor;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private ProcessDataPipeline processDataPipeline;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void process(Page page) {
        String sorry;
        List items;
        this.driver = DriverFactory.createDiffDriver(PageLoadStrategy.NORMAL);
        HashMap map = new HashMap();
        String paterUrl = page.getUrl().toString();
        String keyword = (String)page.getRequest().getExtra("keyword");
        this.driver.get(paterUrl);
        PageOperateUtil.pageRefreshOder(this.driver);
        Page page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
        Html html = page0.getHtml();
        String maxSize = html.css("b.pagination-page-total").xpath("///allText()").get();
        int totalPage = 1;
        if (maxSize != null) {
            totalPage = Integer.parseInt(maxSize);
        }
        if (CollectionUtils.isEmpty((Collection)(items = html.$("div.goods-item-wrap-new").nodes()))) {
            log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u65f6IP\u88ab\u5c01");
            CalcuLateDistanceUtil.calcuLateDistance(this.driver);
            PageOperateUtil.pageRefreshOder(this.driver);
            try {
                Random random = new Random();
                TimeUnit.SECONDS.sleep(random.nextInt(5));
            }
            catch (Exception e) {
                log.info("\u7761\u7720\u5931\u8d25");
            }
            page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
            html = page0.getHtml();
            maxSize = html.css("b.pagination-page-total").xpath("///allText()").get();
            totalPage = maxSize == null ? 0 : Integer.parseInt(maxSize);
        }
        if ((sorry = html.$("div.right-content h3").xpath("///allText()").get()) != null) {
            totalPage = 0;
        }
        log.info("\u9707\u5764\u884c\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)totalPage);
        if (totalPage == 0) {
            this.driver.quit();
        } else {
            this.pageProcess(page0, 1, totalPage, keyword);
        }
        int currentPage = 2;
        for (int i = 2; i <= totalPage; ++i) {
            try {
                WebElement next = this.driver.findElementByClassName("nextbtn");
                next.click();
            }
            catch (Exception e) {
                break;
            }
            PageOperateUtil.pageRefreshOder(this.driver);
            Page page1 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
            log.info("\u5f53\u524d\u9875\u4e3a{}\u9875", (Object)currentPage);
            this.pageProcess(page1, currentPage, totalPage, keyword);
            ++currentPage;
        }
        this.driver.quit();
    }

    private void pageProcess(Page page, int currentPage, int totalPage, String keyword) {
        String paterUrl = page.getUrl().toString();
        Html html = page.getHtml();
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(paterUrl);
        String categoryId = matcher.replaceAll("").trim();
        List divs = html.$("div.goods-item-wrap-new").nodes();
        log.info("\u7b2c{}\u9875\u5904\u7406\u6570\u636e\u5f00\u59cb,\u6570\u636e\u6709{}\u6761", (Object)currentPage, (Object)divs.size());
        ArrayList goodsList = new ArrayList();
        boolean flag = false;
        if (currentPage == totalPage) {
            flag = true;
            int num = 1;
            while (divs.size() == 0) {
                try {
                    PageOperateUtil.pageRefreshOder(this.driver);
                    Thread.sleep(300L);
                    Page page1 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                    Html html1 = page1.getHtml();
                    divs = html1.$("div.goods-item-wrap-new").nodes();
                    if (num > 2 && divs.size() == 0) {
                        log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u4e0b{}\u5206\u7c7b\u65f6IP\u88ab\u5c01", (Object)categoryId);
                        this.driver.executeScript("history.go(0)", new Object[0]);
                        Thread.sleep(300L);
                        CalcuLateDistanceUtil.calcuLateDistance(this.driver);
                        Thread.sleep(2000L);
                        WebElement input = this.driver.findElementByClassName("zxfinput");
                        input.sendKeys(new CharSequence[]{String.valueOf(currentPage)});
                        WebElement button = this.driver.findElementByClassName("zxfokbtn");
                        button.click();
                    }
                    if (num > 3) {
                        log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u4e0b{}\u5206\u7c7b\u65f6{}\u9875\u6570\u636e\u4e0d\u5168", (Object)categoryId, (Object)currentPage);
                        break;
                    }
                    ++num;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (totalPage == 0) {
            log.info("\u9707\u5764\u884c\u5546\u57ce{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u4efb\u4f55\u6570\u636e", (Object)categoryId);
        } else {
            int num = 1;
            while (divs.size() < 60) {
                try {
                    PageOperateUtil.pageRefreshOder(this.driver);
                    Thread.sleep(300L);
                    Page page1 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                    Html html1 = page1.getHtml();
                    divs = html1.$("div.goods-item-wrap-new").nodes();
                    log.info("\u7ecf\u8fc7{}\u6b21\u5faa\u73af\u7b49\u5f85\uff0c\u6570\u636e\u4e3a{}\u6761", (Object)num, (Object)divs.size());
                    if (divs.size() == 0) {
                        log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u4e0b{}\u5206\u7c7b\u65f6IP\u88ab\u5c01", (Object)categoryId);
                        this.driver.executeScript("history.go(0)", new Object[0]);
                        Thread.sleep(300L);
                        CalcuLateDistanceUtil.calcuLateDistance(this.driver);
                        Thread.sleep(2000L);
                        WebElement input = this.driver.findElementByClassName("zxfinput");
                        input.sendKeys(new CharSequence[]{String.valueOf(currentPage)});
                        WebElement button = this.driver.findElementByClassName("zxfokbtn");
                        button.click();
                    }
                    if (num > 3) {
                        log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u4e0b{}\u5206\u7c7b\u65f6{}\u9875\u6570\u636e\u4e0d\u5168", (Object)categoryId, (Object)currentPage);
                        break;
                    }
                    ++num;
                }
                catch (Exception e) {
                    log.info("\u56fe\u5f62\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
                }
            }
        }
        log.info("\u7b2c{}\u9875\u6570\u636e\u6b63\u5e38", (Object)currentPage);
        divs.forEach(item -> {
            String link = item.$("a", "href").get();
            String name = item.css("div.goods-name").xpath("///allText()").get();
            String imgPath = item.css("div.goods-img img").xpath("///@src").get();
            String integer = item.css("span.integer").xpath("///allText()").get();
            String decimal = item.css("span.decimal").xpath("///allText()").get();
            BigDecimal price = new BigDecimal(0);
            if (integer != null || decimal != null) {
                StringBuilder money = new StringBuilder();
                money.append(integer).append(decimal);
                price = new BigDecimal(money.toString());
            }
            Pattern pattern1 = Pattern.compile("(?<item>/item/)(?<goodsNo>\\w*)(?<html>.html)");
            String goodsNo = null;
            Matcher matcher1 = pattern1.matcher(link);
            if (matcher1.find()) {
                goodsNo = matcher1.group("goodsNo");
            } else {
                log.info("\u9707\u5764\u884c\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u83b7\u53d6categoryId\u5931\u8d25");
            }
            StringBuilder url = new StringBuilder();
            url.append("https://www.zkh.com/item/").append(goodsNo).append(".html");
            Goods article = new Goods();
            article.setPrefix(MallType.ZKH.getCode());
            article.setGoodsNo(goodsNo);
            article.setSkuId(goodsNo);
            article.setTitle(name);
            article.setPrice(price);
            article.setPic(imgPath);
            article.setUrl(url.toString());
            article.setCategoryId(categoryId);
            article.setCreated(new Date());
            goodsList.add(article);
        });
        executorService.submit(() -> this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword));
    }

    public Site getSite() {
        return Site.me();
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.zkhDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

