/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ControllerLoggerAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerLoggerAspect.class);

    @Pointcut(value="execution(* com.tydic.nicc.spider.web.SpiderController.*(..))")
    public void spiderController() {
    }

    @Around(value="spiderController()")
    public Object LoggingBefore(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        StringBuilder buffer = new StringBuilder();
        for (Object arg : args) {
            buffer.append(arg.toString());
        }
        MethodSignature signature = (MethodSignature)point.getSignature();
        String methodName = signature.getMethod().getName();
        String params = buffer.toString();
        log.info("{}\u65b9\u6cd5\u88ab\u8c03\u7528\uff0c\u5165\u53c2\u4e3a {}", (Object)methodName, (Object)params);
        return point.proceed();
    }
}

