/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.aspect;

import com.tydic.nicc.spider.config.aspect.SpiderErrorLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SpiderErrorAspect {
    private static Logger logger = LoggerFactory.getLogger(SpiderErrorAspect.class);

    @Pointcut(value="@annotation(com.tydic.nicc.spider.config.aspect.SpiderErrorLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object handleAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        Object[] args = joinPoint.getArgs();
        Object result = joinPoint.proceed();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String methodName = methodSignature.getName();
        SpiderErrorLog log = methodSignature.getMethod().getAnnotation(SpiderErrorLog.class);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStamp = simpleDateFormat.format(new Date());
        Object resultJson = Objects.isNull(result) ? "" : result;
        logger.info("\u8bf7\u6c42\u65f6\u95f4\u6233: {}", (Object)timeStamp);
        logger.info("\u64cd\u4f5c\u7c7b\u578b: {}", (Object)log.description());
        logger.info("\u8bf7\u6c42\u65b9\u6cd5: \u3010{}\u3011", (Object)methodName);
        logger.info("\u8bf7\u6c42\u53c2\u6570: {}", args);
        String className = joinPoint.getTarget().getClass().toString();
        logger.info("{}", (Object)className);
        result = joinPoint.proceed();
        long rspTime = System.currentTimeMillis() - start;
        logger.info("\u8fd4\u56de\u7ed3\u679c: {}", resultJson);
        logger.info("\u65b9\u6cd5\u8017\u65f6: {}ms", (Object)rspTime);
        return result;
    }

    @AfterThrowing(pointcut="logPointCut() && @annotation(xxlJob)", throwing="e")
    public void around(Throwable e, XxlJob xxlJob) {
        String errorMessage = String.format("xxl-job\u4efb\u52a1\u6267\u884c\u5931\u8d25,\u4efb\u52a1\u540d: %s,\u9519\u8bef\u4fe1\u606f: %s", xxlJob.value(), e.getMessage());
        logger.info(errorMessage);
    }
}

