/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.configuration;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class SyncConfiguration
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SyncConfiguration.class);
    @Value(value="${nicc-plugin.spider.thread-num}")
    private int threadNum;

    @Bean(name={"stb"})
    public ThreadPoolTaskExecutor executor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(4);
        taskExecutor.setMaxPoolSize(5);
        taskExecutor.setQueueCapacity(500);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("async-");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"xy"})
    public ThreadPoolTaskExecutor executors() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(3500);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("async-");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"klp"})
    public ThreadPoolTaskExecutor executorsKlp() {
        int klpThreadNum = 1 + this.threadNum;
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(klpThreadNum);
        taskExecutor.setMaxPoolSize(klpThreadNum);
        taskExecutor.setQueueCapacity(0);
        taskExecutor.setKeepAliveSeconds(0);
        taskExecutor.setThreadNamePrefix("async-klp-");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"gaj"})
    public ThreadPoolTaskExecutor executorsGaj() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(2000);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("async-");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"dlEx"})
    public ThreadPoolTaskExecutor dlExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(2000);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("nbdeli -");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"jdEx"})
    public ThreadPoolTaskExecutor jdExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(2000);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("jd -");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"suningEx"})
    public ThreadPoolTaskExecutor suNingExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(4000);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("suning -");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    @Bean(name={"gomeEx"})
    public ThreadPoolTaskExecutor gomeExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(3);
        taskExecutor.setMaxPoolSize(3);
        taskExecutor.setQueueCapacity(4000);
        taskExecutor.setKeepAliveSeconds(20);
        taskExecutor.setThreadNamePrefix("gome -");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    public Executor getAsyncExecutor() {
        return this.executor();
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (ex, method, params) -> log.error("\u7ebf\u7a0b\u6c60\u6267\u884c\u4efb\u52a1\u53d1\u9001\u672a\u77e5\u9519\u8bef,\u6267\u884c\u65b9\u6cd5\uff1a{}, \u9519\u8bef\u4e3a {} ", (Object)method.getName(), (Object)ex);
    }
}

