/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.factory;

import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CommodityInformationServiceFactory {
    @Resource
    private Map<String, CommodityInformationService> map = new ConcurrentHashMap<String, CommodityInformationService>();

    public void addCategory(String mall) {
        this.map.get(mall).addCategory();
    }

    public void climbCommodityInformation(SpiderBO spiderBo) {
        this.map.get(spiderBo.getMall()).climbCommodityInformation(spiderBo.getParam());
    }

    public void climbCommodityTabulate(SpiderParameterBO parameter) {
        this.map.get(parameter.getMall()).climbCommodityTabulate(parameter);
    }

    public void climbProductDetailsWithCategoryId(String mall, String categoryId) {
        this.map.get(mall).climbProductDetailsWithCategoryId(categoryId);
    }

    public String climbProductDetails(String mall) {
        return this.map.get(mall).climbProductDetails();
    }

    public void climbProductInfoByCache(String mall) {
        this.map.get(mall).climbProductInfoByCache();
    }

    public void climbProductTabByCache(String mall) {
        this.map.get(mall).climbProductTabByCache();
    }

    public void climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        this.map.get(goodsBO.getPrefix()).climbProductDetailsByGoodsNo(goodsBO);
    }

    public Future<String> climbProductDetailsByKeyword(String mall, String keyword) {
        return this.map.get(mall).climbProductDetailsByKeyword(keyword);
    }

    public boolean climbGoodsByKeyword(GoodsBO goodsBO) {
        return this.map.get(goodsBO.getPrefix()).climbGoodsByKeyword(goodsBO);
    }
}

