/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.thread;

import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpiderLiThreadMan
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SpiderLiThreadMan.class);
    private final RedisHelper redisHelper;
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;
    private static final ConcurrentHashMap<String, Boolean> MAP = new ConcurrentHashMap();
    private static final int MAX_THREAD_SIZE = 3;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(3);

    public SpiderLiThreadMan(RedisHelper redisHelper, CommodityInformationServiceFactory commodityInformationServiceFactory) {
        this.redisHelper = redisHelper;
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
    }

    @PostConstruct
    public void init() {
        for (RedisCacheKey redisCacheKey : RedisCacheKey.values()) {
            MAP.put(redisCacheKey.getMall(), false);
        }
    }

    @Override
    public void run() {
    }

    public boolean value(String key) {
        return MAP.get(key);
    }

    public int allSize() {
        int total = 0;
        for (Boolean value : MAP.values()) {
            if (!BooleanUtils.isTrue((Boolean)value)) continue;
            ++total;
        }
        return total;
    }
}

