/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nu.pattern.OpenCV;
import org.apache.commons.io.FileUtils;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcuLateDistanceUtil {
    private static final Logger log = LoggerFactory.getLogger(CalcuLateDistanceUtil.class);

    public static void calcuLateDistance(RemoteWebDriver driver) {
        log.info("\u8fdb\u5165\u6ed1\u52a8\u9a8c\u8bc1");
        String filePath = "/app/shopping-spider/img/";
        String slideBlockPath = filePath + System.currentTimeMillis() + "slideBlock.png";
        String slideBgPath = filePath + System.currentTimeMillis() + "slideBg.png";
        String osName = System.getProperties().getProperty("os.name");
        if ("Windows 10".equals(osName)) {
            filePath = "D:\\";
            slideBlockPath = filePath + "\\" + System.currentTimeMillis() + "slideBlock.png";
            slideBgPath = filePath + "\\" + System.currentTimeMillis() + "slideBg.png";
        }
        try {
            WebElement tcaptchaFrame = driver.findElement(By.id((String)"tcaptcha_iframe"));
            driver.switchTo().frame(tcaptchaFrame);
            WebElement slideBlock = driver.findElementByXPath("//img[@id='slideBlock']");
            WebElement slideBg = driver.findElementByXPath("//img[@id='slideBg']");
            String slideBlockUrl = slideBlock.getAttribute("src");
            String slideBgUrl = slideBg.getAttribute("src");
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u56fe\u7247");
            CalcuLateDistanceUtil.downloadImg(slideBlockUrl, slideBlockPath);
            CalcuLateDistanceUtil.downloadImg(slideBgUrl, slideBgPath);
            log.info("\u56fe\u7247\u4e0b\u8f7d\u5b8c\u6210");
            int slideDistance = CalcuLateDistanceUtil.getSlideDistance(slideBlockPath, slideBgPath);
            log.info("\u9700\u8981\u79fb\u52a8\u7684\u8ddd\u79bb\u4e3a{}px", (Object)slideDistance);
            Actions actions = new Actions((WebDriver)driver);
            WebElement dragElement = driver.findElement(By.id((String)"tcaptcha_drag_button"));
            slideDistance = slideDistance * 280 / 680 - 23;
            log.info("\u7ecf\u8fc7\u6362\u7b97\u4e4b\u540e\u9700\u8981\u79fb\u52a8\u7684\u8ddd\u79bb\u4e3a{}px", (Object)slideDistance);
            actions.clickAndHold(dragElement).perform();
            List<Integer> moveTrack = CalcuLateDistanceUtil.getMoveTrack(slideDistance);
            for (Integer index : moveTrack) {
                actions.moveByOffset(index.intValue(), 0).perform();
            }
            actions.release().perform();
        }
        catch (Exception e) {
            log.info("\u6ed1\u52a8\u89e3\u9501\u5931\u8d25", (Throwable)e);
        }
    }

    public static void downloadImg(String url, String filePath) throws IOException {
        File file = new File(filePath);
        FileUtils.copyURLToFile((URL)new URL(url), (File)file);
    }

    public static int getSlideDistance(String slideBlockPicPath, String slideBgPicPath) {
        log.info("\u5f00\u59cb\u5904\u7406\u8ddd\u79bb");
        String osName = System.getProperties().getProperty("os.name");
        if ("Linux".equals(osName)) {
            String soPath = "/app/shopping-spider/libopencv_java320.so";
            log.info("\u52a0\u8f7d\u6587\u4ef6");
            System.load(soPath);
            log.info("\u52a0\u8f7d\u6587\u4ef6\u5b8c\u6bd5");
        } else {
            OpenCV.loadShared();
        }
        log.info("\u5bf9\u6ed1\u5757\u8fdb\u884c\u5904\u7406");
        Mat slideBlockMat = Imgcodecs.imread((String)slideBlockPicPath);
        log.info("\u7070\u5ea6\u5316\u56fe\u7247");
        Imgproc.cvtColor((Mat)slideBlockMat, (Mat)slideBlockMat, (int)6);
        log.info("\u7070\u5ea6\u5316\u56fe\u7247");
        for (int row = 0; row < slideBlockMat.height(); ++row) {
            for (int col = 0; col < slideBlockMat.width(); ++col) {
                if (slideBlockMat.get(row, col)[0] != 0.0) continue;
                slideBlockMat.put(row, col, new double[]{96.0});
            }
        }
        log.info("\u4e8c\u503c\u5316\u8f6c\u9ed1\u767d\u56fe");
        Core.inRange((Mat)slideBlockMat, (Scalar)Scalar.all((double)96.0), (Scalar)Scalar.all((double)96.0), (Mat)slideBlockMat);
        log.info("\u5904\u7406\u6ed1\u52a8\u80cc\u666f\u56fe");
        Mat slideBgMat = Imgcodecs.imread((String)slideBgPicPath);
        Imgproc.cvtColor((Mat)slideBgMat, (Mat)slideBgMat, (int)6);
        Imgproc.threshold((Mat)slideBgMat, (Mat)slideBgMat, (double)127.0, (double)255.0, (int)0);
        Mat g_result = new Mat();
        Imgproc.matchTemplate((Mat)slideBgMat, (Mat)slideBlockMat, (Mat)g_result, (int)5);
        Point matchLocation = Core.minMaxLoc((Mat)g_result).maxLoc;
        log.info("\u6a2a\u5411\u8ddd\u79bb\u4e3a{}", (Object)matchLocation.x);
        return (int)matchLocation.x;
    }

    public static List<Integer> getMoveTrack(int distance) {
        ArrayList<Integer> track = new ArrayList<Integer>();
        Random random = new Random();
        int current = 0;
        int mid = distance * 4 / 5;
        int a = 0;
        int move = 0;
        while (true) {
            a = random.nextInt(10);
            move = current <= mid ? (move += a) : (move -= a);
            if (current + move >= distance) break;
            track.add(move);
            current += move;
        }
        track.add(distance - current);
        return track;
    }

    public static final Class getCurrentClass() {
        return new Object(){

            public Class getClassForStatic() {
                return this.getClass();
            }
        }.getClassForStatic();
    }
}

