/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ChineseCharactersUtils {
    public static String toFirstChar(String chinese) throws BadHanyuPinyinOutputFormatCombination {
        String pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            pinyinStr = newChar[i] > '\u0080' ? pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0) : pinyinStr + newChar[i];
        }
        return pinyinStr;
    }

    public static String toPinyin(String chinese) {
        String pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinStr = pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinStr = pinyinStr + newChar[i];
        }
        if (pinyinStr.contains("\\")) {
            String pinyinStrr = pinyinStr.replaceAll("\\\\", "_");
            return pinyinStrr;
        }
        if (pinyinStr.contains("/")) {
            String pinyinStrrr = pinyinStr.replaceAll("/", "_");
            return pinyinStrrr;
        }
        return pinyinStr;
    }
}

