/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRegexUtil {
    private static final Logger log = LoggerFactory.getLogger(ProcessRegexUtil.class);
    public static final String SN_SKU_REGEX = "\\&cmdCode=([0-9]*?)&";
    public static final String DL_CATEGORYID_REGEX = "\\&categoryUuid=.*&";
    public static final String JD_PRICE_REGEX = "^[\\.\\d]*$";
    public static final String EXTRACT_NUMBERS_REGEX = "\\d+";
    public static final String XY_GOODSNO_REGEX = "(?<item>https://)(?<ym>www.ehsy.com)(?<product>/product-)(?<goodsNo>\\w+)";
    public static final String GAJ_TOTALPAGE_REGEX = "(?<totalPage>\u5171\\w+\u9875)";
    public static final String GAJ_DATANUMBER_REGEX = "(?<dataNumber>\u6bcf\u9875\\w+\u6761)";
    public static final String GAJ_GOODSNO_REGEX = "(?<u>/u-)(?<goodsNo>\\w+)(?<html>.html)";
    public static final String KLP_GOODSNO_REGEX = "((?<goodsNo>\\d*)(?<html>.html))";

    public static String processSnSku(String target) {
        Pattern pattern = Pattern.compile(SN_SKU_REGEX);
        Matcher matcher = pattern.matcher(target);
        matcher.find();
        return matcher.group();
    }

    public static String processDlCategoryId(String target) {
        Pattern pattern = Pattern.compile(DL_CATEGORYID_REGEX);
        Matcher matcher = pattern.matcher(target);
        matcher.find();
        return matcher.group();
    }

    public static boolean processJdPrice(String target) {
        Pattern pattern = Pattern.compile(JD_PRICE_REGEX);
        Matcher matcher = pattern.matcher(target);
        boolean result = matcher.find();
        return result;
    }

    public static String extractNumbers(String target) {
        Pattern pattern = Pattern.compile(EXTRACT_NUMBERS_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String processXyGoodsNo(String target) {
        Pattern pattern = Pattern.compile(XY_GOODSNO_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            return matcher.group("goodsNo");
        }
        return null;
    }

    public static String processGajTotalPage(String target) {
        Pattern pattern = Pattern.compile(GAJ_TOTALPAGE_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            String str = matcher.group("totalPage");
            pattern = Pattern.compile(EXTRACT_NUMBERS_REGEX);
            matcher = pattern.matcher(str);
            if (matcher.find()) {
                String totalPage = matcher.group();
                return totalPage;
            }
            return null;
        }
        return null;
    }

    public static String processGajDataNumber(String target) {
        Pattern pattern = Pattern.compile(GAJ_DATANUMBER_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            String str = matcher.group("dataNumber");
            pattern = Pattern.compile(EXTRACT_NUMBERS_REGEX);
            matcher = pattern.matcher(str);
            if (matcher.find()) {
                String totalPage = matcher.group();
                return totalPage;
            }
            return null;
        }
        return null;
    }

    public static String processGajGoodsNo(String target) {
        Pattern pattern = Pattern.compile(GAJ_GOODSNO_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            return matcher.group("goodsNo");
        }
        return null;
    }

    public static String processStbCategoryId(String target) {
        Pattern pattern = Pattern.compile(EXTRACT_NUMBERS_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String processKlpGoodsNo(String target) {
        Pattern pattern = Pattern.compile(KLP_GOODSNO_REGEX);
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            return matcher.group("goodsNo");
        }
        return null;
    }
}

