/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheInfoServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CacheInfoServiceImpl.class);
    @Autowired
    private RedisHelper redisHelper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private CategoryMapper categoryMapper;
    private static final long DEFAULT_DET_COUNT = 50L;
    private static final long DEFAULT_LIST_COUNT = 1L;
    private static final long DEFAULT_LOCK_EXPIRE_TIME = 10L;
    private static final long DEFAULT_QUEUE_EXPIRE_TIME = 24L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDet(@NotNull RedisCacheKey redisCacheKey, List<String> categoryIdList) {
        block12: {
            if (CollectionUtils.isEmpty(categoryIdList)) {
                return;
            }
            try {
                List goodsDetCacheList = this.goodsMapper.selectListByCategoryIdList(redisCacheKey.getMall(), categoryIdList);
                if (!CollectionUtils.isNotEmpty((Collection)goodsDetCacheList)) break block12;
                List objList = goodsDetCacheList.stream().map(goods -> goods).collect(Collectors.toList());
                String queueKey = redisCacheKey.getQueueKey();
                if (this.redisHelper.hasKey(queueKey)) {
                    RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(redisCacheKey.getLockKey()).requestId(IdWorker.nextAutoIdStr()).build();
                    while (true) {
                        if (this.redisHelper.lockLua(redisLockEntity, 10L)) {
                            log.info("\u6210\u529f\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getLockKey());
                            try {
                                if (this.redisHelper.lSetList(queueKey, objList, TimeUnit.HOURS.toSeconds(24L))) {
                                    log.info("\u7f13\u5b58\u961f\u5217\u5b8c\u6210 {} ", (Object)queueKey);
                                    return;
                                }
                            }
                            finally {
                                this.redisHelper.unlockLua(redisLockEntity);
                            }
                        }
                        log.info("\u5931\u8d25\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getLockKey());
                    }
                }
                while (true) {
                    if (this.redisHelper.lSetList(queueKey, objList, TimeUnit.HOURS.toSeconds(24L))) {
                        log.info("\u7f13\u5b58\u961f\u5217\u5b8c\u6210 {} ", (Object)queueKey);
                        return;
                    }
                    log.info("\u7f13\u5b58\u961f\u5217\u5931\u8d25 {} ", (Object)queueKey);
                }
            }
            catch (Exception e) {
                log.error("\u7f13\u5b58\u961f\u5217\u65b9\u6cd5\u6267\u884c\u5f02\u5e38 {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> getDetWithCount(@NotNull RedisCacheKey redisCacheKey, long count) {
        String queueKey = redisCacheKey.getQueueKey();
        if (!this.redisHelper.hasKey(queueKey)) return null;
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(redisCacheKey.getLockKey()).requestId(IdWorker.nextAutoIdStr()).build();
        while (true) {
            try {
                if (!this.redisHelper.lockLua(redisLockEntity, 10L)) continue;
                log.info("\u6210\u529f\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getLockKey());
                List objectList = this.redisHelper.lGet(queueKey, 0L, count <= 0L ? 49L : count - 1L);
                if (objectList == null) continue;
                log.info("\u6210\u529f\u83b7\u53d6 {} \u961f\u5217\u6570\u636e ", (Object)queueKey);
                if (!this.redisHelper.lTrim(queueKey, (long)objectList.size(), -1L)) continue;
                log.info("\u6210\u529f\u6e05\u9664 {} \u90e8\u5206\u961f\u5217\u6570\u636e ", (Object)queueKey);
                List list = objectList;
                return list;
            }
            catch (Exception e) {
                log.error("getDetWithCount is error {}", (Object)e.getMessage());
                continue;
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
                log.info("\u6210\u529f\u91ca\u653e\u9501 {} ", (Object)redisCacheKey.getLockKey());
                continue;
            }
            break;
        }
    }

    public List<Goods> getGoodsCache(@NotNull RedisCacheKey redisCacheKey, long count) {
        List<Object> objectList = this.getDetWithCount(redisCacheKey, count);
        JSONArray jsonArray = JSONUtil.parseArray(objectList);
        return JSONUtil.toList((JSONArray)jsonArray, Goods.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLi(@NotNull RedisCacheKey redisCacheKey, List<String> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return;
        }
        List poList = this.categoryMapper.selectListByCategoryIdList(redisCacheKey.getMall(), categoryIdList);
        if (CollectionUtils.isNotEmpty((Collection)poList)) {
            List objList = poList.stream().map(po -> po).collect(Collectors.toList());
            String listQueueKey = redisCacheKey.getListQueueKey();
            if (this.redisHelper.hasKey(listQueueKey)) {
                RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(redisCacheKey.getListLockKey()).requestId(IdWorker.nextAutoIdStr()).build();
                while (true) {
                    if (this.redisHelper.lockLua(redisLockEntity, 10L)) {
                        log.info("\u6210\u529f\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getListLockKey());
                        try {
                            if (this.redisHelper.lSetList(listQueueKey, objList, TimeUnit.HOURS.toSeconds(24L))) {
                                log.info("\u7f13\u5b58\u961f\u5217\u5b8c\u6210 {} ", (Object)listQueueKey);
                                return;
                            }
                        }
                        finally {
                            this.redisHelper.unlockLua(redisLockEntity);
                        }
                    }
                    log.info("\u5931\u8d25\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getListLockKey());
                }
            }
            while (true) {
                if (this.redisHelper.lSetList(listQueueKey, objList, TimeUnit.HOURS.toSeconds(24L))) {
                    log.info("\u7f13\u5b58\u961f\u5217\u5b8c\u6210 {} ", (Object)listQueueKey);
                    return;
                }
                log.info("\u7f13\u5b58\u961f\u5217\u5931\u8d25 {} ", (Object)listQueueKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> getLi(@NotNull RedisCacheKey redisCacheKey, long count) {
        String listQueueKey = redisCacheKey.getListQueueKey();
        if (!this.redisHelper.hasKey(listQueueKey)) return null;
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(redisCacheKey.getListLockKey()).requestId(IdWorker.nextAutoIdStr()).build();
        while (true) {
            try {
                if (!this.redisHelper.lockLua(redisLockEntity, 10L)) continue;
                log.info("\u6210\u529f\u83b7\u53d6\u9501 {} ", (Object)redisCacheKey.getListLockKey());
                List objectList = this.redisHelper.lGet(listQueueKey, 0L, count <= 0L ? 0L : count - 1L);
                log.info("\u6210\u529f\u83b7\u53d6 {} \u961f\u5217\u6570\u636e ", (Object)listQueueKey);
                if (!this.redisHelper.lTrim(listQueueKey, (long)objectList.size(), -1L)) continue;
                log.info("\u6210\u529f\u6e05\u9664 {} \u90e8\u5206\u961f\u5217\u6570\u636e ", (Object)listQueueKey);
                List list = objectList;
                return list;
            }
            catch (Exception e) {
                log.error("getLi is error {}", (Object)e.getMessage());
                continue;
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
                log.info("\u6210\u529f\u91ca\u653e\u9501 {} ", (Object)redisCacheKey.getListLockKey());
                continue;
            }
            break;
        }
    }

    public List<CategoryPO> getGoodsLiCache(@NotNull RedisCacheKey redisCacheKey, long count) {
        List<Object> objectList = this.getLi(redisCacheKey, count);
        if (objectList != null) {
            return objectList.stream().map(obj -> (CategoryPO)obj).collect(Collectors.toList());
        }
        return null;
    }
}

