/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.GajCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.GajDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.GajProcessor;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Service(value="mymro")
public class GajSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(GajSpiderServiceImpl.class);
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private GajCategoryProcessor gajCategoryProcessor;
    @Autowired
    private GajProcessor gajProcessor;
    @Autowired
    private CategoryPipeline categoryPipeline;
    @Autowired
    private GajDescriptionProcessor gajDescriptionProcessor;
    @Autowired
    private GoodsDetailPipeline goodsDetailPipeline;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void addCategory() {
        String url = "https://www.mymro.cn/c-000001.html";
        Spider.create((PageProcessor)this.gajCategoryProcessor).addRequest(new Request[]{new Request(url)}).addPipeline((Pipeline)this.categoryPipeline).run();
    }

    public void climbCommodityTabulate(SpiderParameterBO parameter) {
        long startTime0 = System.currentTimeMillis();
        List categoryIdList = parameter.getCategoryIdList();
        List urlList = parameter.getUrlList();
        if (CollectionUtils.isNotEmpty((Collection)urlList)) {
            urlList.forEach(url -> {
                long startTime = System.currentTimeMillis();
                Spider.create((PageProcessor)this.gajProcessor).addRequest(new Request[]{new Request(url)}).setExitWhenComplete(true).run();
                long endTime = System.currentTimeMillis();
                log.info("\u56fa\u5b89\u6377\u5546\u57ce\u722c\u53d6:{}\u5206\u7c7b\u9700\u8981:{}ms", url, (Object)(endTime - startTime));
            });
        } else {
            categoryIdList.forEach(categoryId -> {
                StringBuilder url = new StringBuilder();
                url.append("https://www.mymro.cn/c-").append((String)categoryId).append(".html");
                long startTime = System.currentTimeMillis();
                Spider.create((PageProcessor)this.gajProcessor).addRequest(new Request[]{new Request(url.toString())}).run();
                long endTime = System.currentTimeMillis();
                log.info("\u56fa\u5b89\u6377\u5546\u57ce\u722c\u53d6:{}\u5206\u7c7b\u9700\u8981:{}ms", categoryId, (Object)(endTime - startTime));
            });
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u56fa\u5b89\u6377\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
    }

    @Async(value="gaj")
    public void climbProductDetailsWithCategoryId(String categoryId) {
        List goodsList = this.goodsMapper.selectListByCategoryId(MallType.GAJ.getCode(), categoryId);
        if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
            this.spiderDescPro(goodsList, null);
        } else {
            log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
        }
    }

    private void spiderDescPro(List<Goods> goodsList, String keyword) {
        int num;
        int lastIndex = num = 100;
        int i = 0;
        while (i < goodsList.size()) {
            if (lastIndex >= goodsList.size()) {
                this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                break;
            }
            this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
            i = lastIndex;
            lastIndex = i + num;
        }
    }

    private void spiderDesc(List<Goods> goodsList, String keyword) {
        long startTime = System.currentTimeMillis();
        Request request = new Request();
        HashMap hashMap = new HashMap();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList.forEach(goods -> {
                try {
                    this.spiderDetail(hashMap, request, (Goods)goods, null);
                }
                catch (Exception e) {
                    log.error("\u56fa\u5b89\u6377\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            });
            long endTime = System.currentTimeMillis();
            log.info("\u56fa\u5b89\u6377\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.gajDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public void climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, "oneDetail");
        }
        catch (Exception e) {
            log.error("Gaj\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    @Async(value="gaj")
    public Future<String> climbProductDetailsByKeyword(String keyword) {
        try {
            JSONObject object;
            String result;
            String url = "https://gateway.mymro.cn/website/product_provider/search/keyword";
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("goodType", "01");
            param.put("currentPage", 1);
            param.put("keyword", keyword);
            param.put("pageSize", "60");
            String resultStr = JSON.toJSONString(param);
            HttpResponse httpResponse = HttpRequest.post((String)url).body(resultStr, "application/json").execute();
            if (httpResponse.isOk() && (result = httpResponse.body()) != null && (object = JSONObject.parseObject((String)result)).getString("errCode").equals("200")) {
                this.parsePage(result, param, url);
            }
        }
        catch (Exception e) {
            log.error("\u56fa\u5b89\u6377\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        return null;
    }

    private void parsePage(String rawText, Map<String, Object> param, String url) {
        JsonPathSelector current = new JsonPathSelector("$.data.productResponseList.current");
        JsonPathSelector size = new JsonPathSelector("$.data.productResponseList.size");
        JsonPathSelector total = new JsonPathSelector("$.data.productResponseList.total");
        JsonPathSelector jsonPathSelector = new JsonPathSelector("$.data.productResponseList.records");
        JsonPathSelector productSelector = new JsonPathSelector("$.productItems");
        JsonPathSelector itemCodeSelector = new JsonPathSelector("$.itemCode");
        JsonPathSelector marketPriceSelector = new JsonPathSelector("$.marketPrice");
        JsonPathSelector nameSelector = new JsonPathSelector("$.name");
        int currentPage = Integer.parseInt(current.select(rawText));
        int pageSize = Integer.parseInt(size.select(rawText));
        int count = Integer.parseInt(total.select(rawText));
        if (count == 0) {
            return;
        }
        int totalPage = count / pageSize + 1;
        for (int i = currentPage; i < totalPage + 1; ++i) {
            JSONObject object;
            String result;
            param.put("currentPage", i);
            String resultStr = JSON.toJSONString(param);
            HttpResponse httpResponse = HttpRequest.post((String)url).body(resultStr, "application/json").execute();
            if (!httpResponse.isOk() || (result = httpResponse.body()) == null || !(object = JSONObject.parseObject((String)result)).getString("errCode").equals("200")) continue;
            List spuList = jsonPathSelector.selectList(result);
            log.info("spuList" + spuList.size());
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            for (String json : spuList) {
                List skuList = productSelector.selectList(json);
                for (String sku : skuList) {
                    Goods goods = new Goods();
                    goods.setPrefix(MallType.GAJ.getCode());
                    goods.setGoodsNo(itemCodeSelector.select(sku));
                    goods.setSkuId(goods.getGoodsNo());
                    goods.setTitle(nameSelector.select(sku));
                    goods.setPrice(new BigDecimal(marketPriceSelector.select(sku)));
                    goods.setUrl("https://www.mymro.cn/u-" + goods.getGoodsNo() + ".html");
                    goodsList.add(goods);
                }
            }
            this.processDataPipeline.processDataList(goodsList, i, totalPage, param.get("keyword").toString());
            executorService.submit(() -> this.spiderDescPro(goodsList, param.get("keyword").toString()));
        }
    }
}

