/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.ProxyService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.compoent.pipeline.JdCategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.JdCategoryProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.description.JdDescriptionProcessorApi;
import com.tydic.nicc.spider.compoent.processor.description.JdDescriptionProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.JdProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.JdSearchProcessorWithSelfDriver;
import com.tydic.nicc.spider.config.exception.ChromeDriverException;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import com.tydic.nicc.spider.vo.JdCategoryVO;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="jd")
public class JdSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(JdSpiderServiceImpl.class);
    private final JdCategoryPipeline jdCategoryPipeline;
    private final ProcessDataPipeline processDataPipeline;
    private final CacheInfoServiceImpl cacheInfoServiceImpl;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private CategoryMapper categoryMapper;
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    @Value(value="${nicc-plugin.spider.spiderTime}")
    private long spiderTime;
    @Value(value="${nicc-plugin.spider.jdcookie}")
    private String cookie;
    @Value(value="${nicc-plugin.chrome.proxy.urls}")
    private String ipAdress;
    @Resource
    private ProxyService proxyService;
    @Autowired
    private RedisHelper redisHelper;
    @Autowired
    private JdSearchProcessorWithSelfDriver jdSearchProcessorWithSelfDriver;
    @Autowired
    private JdDescriptionProcessorWithSelfDriver jdDescriptionProcessorWithSelfDriver;
    @Autowired
    private JdDescriptionProcessorApi jdDescriptionProcessorApi;

    public JdSpiderServiceImpl(JdCategoryPipeline jdCategoryPipeline, ProcessDataPipeline processDataPipeline, CacheInfoServiceImpl cacheInfoServiceImpl) {
        this.jdCategoryPipeline = jdCategoryPipeline;
        this.processDataPipeline = processDataPipeline;
        this.cacheInfoServiceImpl = cacheInfoServiceImpl;
    }

    public void addCategory() {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        try {
            Map<String, List<Map<String, List<JdCategoryVO>>>> dataMap = JdCategoryProcessorWithSelfDriver.process(selfDriver);
            this.jdCategoryPipeline.process(dataMap);
        }
        catch (Exception e) {
            log.error("addCategory is error {}", (Object)e.getMessage());
        }
        finally {
            selfDriver.getDriver().quit();
        }
        log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b\u4fe1\u606f\u722c\u53d6\u5b8c\u6210");
    }

    public void climbCommodityTabulate(SpiderParameterBO parameter) {
        long startTime = System.currentTimeMillis();
        List categoryIdList = parameter.getCategoryIdList();
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        if (CollectionUtils.isNotEmpty((Collection)categoryIdList)) {
            for (String categoryId : categoryIdList) {
                CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
                if (!Objects.isNull(categoryPO)) {
                    if (StringUtils.isNotBlank((CharSequence)parameter.getExtraUrlParam())) {
                        String conditionUrl = categoryPO.getUrl() + parameter.getExtraUrlParam();
                        log.info("conditionUrl{}", (Object)conditionUrl);
                        categoryPO.setUrl(conditionUrl);
                    }
                    try {
                        JdProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver);
                    }
                    catch (ChromeDriverException e) {
                        log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Object)selfDriver.hashCode());
                        selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                        log.error("\u66f4\u6362driver\u540e,selfDriver is {}", (Object)selfDriver.hashCode());
                    }
                }
                log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryId);
            }
        } else {
            List urlList = parameter.getUrlList();
            for (String url : urlList) {
                if (BooleanUtils.isTrue((Boolean)MallState.JD.isState())) break;
                CategoryPO categoryPO = this.categoryMapper.selectCategoryIdByUrl(url);
                if (!Objects.isNull(categoryPO)) {
                    try {
                        JdProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver);
                    }
                    catch (ChromeDriverException e) {
                        log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Object)selfDriver.hashCode());
                        selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                        log.error("\u66f4\u6362driver\u540e,selfDriver is {}", (Object)selfDriver.hashCode());
                    }
                }
                log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryPO.getCategoryId());
            }
        }
        selfDriver.getDriver().quit();
        long endTime = System.currentTimeMillis();
        log.info("\u4eac\u4e1c\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}\u5206\u949f", (Object)TimeUnit.MILLISECONDS.toMinutes(endTime - startTime));
    }

    @Async(value="jdEx")
    public void climbProductDetailsWithCategoryId(String categoryId) {
        List goodsList = this.goodsMapper.selectListByCategoryId(MallType.JD.getCode(), categoryId);
        log.info("\u4eac\u4e1c\u5546\u57ce{}\u5206\u7c7b\u4e0b\u5217\u8868\u6570\u636e\u5927\u5c0f\u4e3a\uff1a{}", (Object)categoryId, (Object)goodsList.size());
        if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
            this.processCacheDet(goodsList, null);
        }
    }

    public void climbProductInfoByCache() {
        RedisCacheKey redisCacheKey = RedisCacheKey.fromMall(MallType.JD.getCode());
        List<Goods> goodsList;
        while (!CollectionUtils.isEmpty(goodsList = this.cacheInfoServiceImpl.getGoodsCache(redisCacheKey, 50L))) {
            this.processCacheDet(goodsList, null);
        }
        return;
    }

    private void processCacheDet(List<Goods> goodsList, String keyword) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
                i = lastIndex;
                lastIndex = i + num;
            }
        }
        log.info("JdSpiderServiceImpl driver exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spiderDesc(List<Goods> goodsList, String keyword) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        for (Goods goods : goodsList) {
            SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            try {
                Map<String, Object> dataMap = this.jdDescriptionProcessorWithSelfDriver.process(selfDriver.getDriver(), goods);
                if (Objects.isNull(dataMap)) continue;
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                if (goods1 != null && goods1.getGoodsNo() != null) {
                    goodList.add(goods1);
                }
                if (goodsDetailsWithBLOBs == null || goodsDetailsWithBLOBs.getGoodsNo() == null) continue;
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            catch (Exception e) {
                log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Throwable)e);
            }
            finally {
                selfDriver.getDriver().quit();
            }
        }
        map.put("goodsList", goodList);
        map.put("goodsDetailsList", goodsDetailsList);
        map.put("keyword", keyword);
        this.processDataPipeline.processDataMap(map);
    }

    public void climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map<String, Object> dataMap = this.jdDescriptionProcessorApi.process(goods);
            if (!Objects.isNull(dataMap)) {
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                if (goodsDetailsWithBLOBs != null) {
                    goodsDetailsList.add(goodsDetailsWithBLOBs);
                }
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", "oneDetail");
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    @Async(value="jdEx")
    public Future<String> climbProductDetailsByKeyword(String keyword) {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        try {
            String url = "https://search.jd.com/Search?keyword=" + keyword + "&enc=utf-8";
            URLEncoder.encode(url, "utf-8");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            JdProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        selfDriver.getDriver().quit();
        return null;
    }

    public boolean climbGoodsByKeyword(GoodsBO goodsBO) {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, this.ipAdress);
        boolean flag = false;
        try {
            String url = "https://search.jd.com/Search?keyword=" + goodsBO.getTitle() + "&enc=utf-8";
            URLEncoder.encode(url, "utf-8");
            flag = this.jdSearchProcessorWithSelfDriver.process(goodsBO, url, this.processDataPipeline, selfDriver);
            TimeUnit.SECONDS.sleep(this.spiderTime);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        finally {
            selfDriver.getDriver().quit();
        }
        return flag;
    }

    private String getIpAdress() {
        String ipAdress = null;
        if (this.enable) {
            if (this.redisHelper.get("spider_proxy_ip") != null) {
                ipAdress = this.redisHelper.get("spider_proxy_ip").toString();
            } else {
                List ips = this.proxyService.getProxy("\u591a\u7c73\u4ee3\u7406", Integer.valueOf(1));
                if (CollectionUtils.isNotEmpty((Collection)ips)) {
                    ipAdress = (String)ips.get(0);
                }
            }
        }
        return ipAdress;
    }

    private RemoteWebDriver loginCookie(RemoteWebDriver driver, String cookie) {
        driver.get("https://jd.com/");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse("2040-12-31 18:00:00");
            if (StringUtils.isNotEmpty((CharSequence)cookie)) {
                Cookie cookie1 = new Cookie("thor", cookie, ".jd.com", null, date, true, true);
                driver.manage().addCookie(cookie1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return driver;
    }
}

