/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.RedisService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.processor.category.KlpCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.KlpDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.KlpProcessor;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="colipu")
public class KlpSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(KlpSpiderServiceImpl.class);
    @Resource
    private KlpCategoryProcessor klpCategoryProcessor;
    @Resource
    private KlpProcessor klpProcessor;
    @Resource
    private CategoryPipeline pipeline;
    @Resource
    private KlpDescriptionProcessor klpDescriptionProcessor;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private RedisService redisService;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private CategoryMapper categoryMapper;

    public void addCategory() {
        String url = "https://list.colipu.com/allofficesupplies";
        Spider.create((PageProcessor)this.klpCategoryProcessor).addUrl(new String[]{url}).addPipeline((Pipeline)this.pipeline).run();
    }

    public void climbCommodityTabulate(SpiderParameterBO parameter) {
        List categoryIdList = parameter.getCategoryIdList();
        long startTime0 = System.currentTimeMillis();
        categoryIdList.forEach(categoryId -> {
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
            if (categoryPO != null) {
                Spider.create((PageProcessor)this.klpProcessor).addUrl(new String[]{categoryPO.getUrl()}).run();
            }
        });
        long endTime0 = System.currentTimeMillis();
        log.info("\u79d1\u529b\u666e\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
    }

    @Async(value="klp")
    public void climbProductDetailsWithCategoryId(String categoryId) {
        List goodsList = this.goodsMapper.selectListByCategoryId(MallType.Klp.getCode(), categoryId);
        if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()));
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex));
                i = lastIndex;
                lastIndex = i + num;
            }
        } else {
            log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
        }
    }

    private void spiderDesc(List<Goods> goodsList) {
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            Request request = new Request();
            HashMap hashMap = new HashMap();
            goodsList.forEach(goods -> {
                try {
                    this.spiderDetail(hashMap, request, (Goods)goods, null);
                }
                catch (Exception e) {
                    log.error("\u79d1\u529b\u666e\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            });
            long endTime = System.currentTimeMillis();
            log.info("\u79d1\u529b\u666e\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.klpDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public void climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, "oneDetail");
        }
        catch (Exception e) {
            log.error("\u79d1\u529b\u666e\u5546\u57ce\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    @Async(value="klp")
    public Future<String> climbProductDetailsByKeyword(String keyword) {
        try {
            String url = "https://www.colipu.com/search.html?q=" + keyword;
            URLEncoder.encode(url, "utf-8");
            Request request = new Request();
            request.putExtra("keyword", (Object)keyword);
            request.setUrl(url);
            Spider.create((PageProcessor)this.klpProcessor).addRequest(new Request[]{request}).run();
        }
        catch (Exception e) {
            log.error("\u79d1\u529b\u666e\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        return null;
    }
}

