/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.spider.api.RedisService;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    private final CategoryMapper categoryMapper;
    private final GoodsMapper goodsMapper;
    private final RedisHelper redisHelper;

    public RedisServiceImpl(CategoryMapper categoryMapper, GoodsMapper goodsMapper, RedisHelper redisHelper) {
        this.categoryMapper = categoryMapper;
        this.goodsMapper = goodsMapper;
        this.redisHelper = redisHelper;
    }

    public void insertData(String mall) {
        List categoryPOList = this.categoryMapper.selectCategoryList(Integer.valueOf(3), mall);
        categoryPOList.forEach(categoryPO -> {
            List goodsList = this.goodsMapper.selectListByCategoryId(mall, categoryPO.getCategoryId());
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                log.info("{}\u52a0\u9501\u5f00\u59cb", (Object)categoryPO.getCategoryId());
                String requestId = IdWorker.nextAutoIdStr();
                String lockKey = RedisCacheKey.fromMall(mall).getLockKey();
                RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(requestId).build();
                boolean locked = this.redisHelper.lockLua(redisLockEntity, 10L);
                if (locked) {
                    log.info("\u52a0\u9501\u6210\u529f\u5e76\u6267\u884c\u63d2\u5165redis\u64cd\u4f5c");
                    log.info("\u6b64\u5206\u7c7b\u4e0b\u6709{}\u6761\u6570\u636e", (Object)goodsList.size());
                    List objectList = goodsList.stream().map(good -> good).collect(Collectors.toList());
                    String queueKey = RedisCacheKey.fromMall(mall).getQueueKey();
                    this.redisHelper.lSetList(queueKey, objectList);
                    log.info("\u63d2\u5165\u6210\u529f");
                    this.redisHelper.unlockLua(redisLockEntity);
                } else {
                    log.info("\u52a0\u9501\u5931\u8d25{}", (Object)categoryPO.getCategoryId());
                }
            } else {
                log.info("{}\u5206\u7c7b\u4e0b\u6570\u636e\u4e3a\u7a7a", (Object)categoryPO.getCategoryId());
            }
        });
    }

    public List<Object> dataFetch(String mall) {
        long size = this.redisHelper.lGetListSize(mall);
        if (size == 0L) {
            return null;
        }
        log.info("\u52a0\u9501\u5f00\u59cb");
        String id = IdWorker.nextAutoIdStr();
        String lockKey = RedisCacheKey.fromMall(mall).getLockKey();
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(id).build();
        boolean locked = this.redisHelper.lockLua(redisLockEntity, 5L);
        if (!locked) {
            return this.dataFetch(mall);
        }
        String queueKey = RedisCacheKey.fromMall(mall).getQueueKey();
        List goodsList = this.redisHelper.lGet(queueKey, 0L, 49L);
        this.redisHelper.lTrim(queueKey, 50L, -1L);
        this.redisHelper.unlockLua(redisLockEntity);
        size = this.redisHelper.lGetListSize(mall);
        if (size == 0L) {
            return null;
        }
        return goodsList;
    }
}

