/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.ecs.model.v20140526.AllocateEipAddressResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.api.bo.CategoryBO;
import com.tydic.nicc.spider.api.bo.CountTaskRedisRspBO;
import com.tydic.nicc.spider.api.bo.DataSkuInfo;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.GoodsNoListReqBO;
import com.tydic.nicc.spider.api.bo.QueryGoodByKeywordReqBO;
import com.tydic.nicc.spider.api.bo.QueryTaskByTimeReqBO;
import com.tydic.nicc.spider.api.bo.QueryTaskListReqBO;
import com.tydic.nicc.spider.api.bo.Resp;
import com.tydic.nicc.spider.api.bo.SaveGoodsInfoReqBO;
import com.tydic.nicc.spider.api.bo.SkuInfoBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.api.bo.SpiderSyncLogBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.config.util.AliApiUtil;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsDetailsMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.SpiderEipMapper;
import com.tydic.nicc.spider.mapper.SpiderLogMapper;
import com.tydic.nicc.spider.mapper.SpiderShopUserMapper;
import com.tydic.nicc.spider.mapper.SpiderSyncLogMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetails;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.mapper.po.SpiderEipPO;
import com.tydic.nicc.spider.mapper.po.SpiderLogPO;
import com.tydic.nicc.spider.mapper.po.SpiderSyncLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpiderServiceImpl
implements SpiderService {
    private static final Logger log = LoggerFactory.getLogger(SpiderServiceImpl.class);
    @Autowired
    private RedisHelper redisHelper;
    private Object lock = new Object();
    @Resource
    private CategoryMapper categoryMapper;
    @Resource
    private SpiderLogMapper spiderLogMapper;
    @Autowired
    private SpiderEipMapper spiderEipMapper;
    @Autowired
    private SpiderSyncLogMapper syncLogMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsDetailsMapper goodsDetailsMapper;
    @Autowired
    private SpiderShopUserMapper spiderShopUserMapper;
    @Value(value="${aliyun.spider.instanceId}")
    private String instanceId;
    @Value(value="${nicc-plugin.spider.jdcookie}")
    private Long cookie;
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;

    public SpiderServiceImpl(CommodityInformationServiceFactory commodityInformationServiceFactory) {
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
    }

    public Rsp receiveSkuInfo(DataSkuInfo reqBO) {
        try {
            List skuInfos = reqBO.getData().getSkuInfos();
            if (CollectionUtils.isNotEmpty((Collection)skuInfos)) {
                SpiderSyncLogPO syncLogPO = SpiderSyncLogPO.builder().createTime(new Date()).sign(reqBO.getPoolName()).spiderType("1").build();
                SpiderSyncLogBO syncLogBO = new SpiderSyncLogBO();
                for (SkuInfoBO skuInfoBO : skuInfos) {
                    SpiderSyncLogPO logPO;
                    syncLogPO.setGoodsNo(skuInfoBO.getSkuId());
                    if (StringUtils.isNotEmpty((CharSequence)skuInfoBO.getExtLink()) && skuInfoBO.getExtLink().contains("?")) {
                        syncLogPO.setUrl(skuInfoBO.getExtLink().split("\\?")[0]);
                    } else {
                        syncLogPO.setUrl(skuInfoBO.getExtLink());
                    }
                    syncLogPO.setTaskTime(skuInfoBO.getTaskTime());
                    syncLogPO.setSerialNo(reqBO.getSerialNo());
                    syncLogPO.setTitle(skuInfoBO.getTitle());
                    if (StringUtils.isNotEmpty((CharSequence)skuInfoBO.getPrice())) {
                        syncLogPO.setPrice(new BigDecimal(skuInfoBO.getPrice()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)skuInfoBO.getJdPrice())) {
                        syncLogPO.setJdPrice(new BigDecimal(skuInfoBO.getJdPrice()));
                    }
                    if ((logPO = this.syncLogMapper.selectByTaskTime(skuInfoBO.getTaskTime(), skuInfoBO.getSkuId())) != null) {
                        syncLogPO.setPid(logPO.getPid());
                        logPO.setPrice(syncLogPO.getPrice());
                        logPO.setJdPrice(syncLogPO.getJdPrice());
                        logPO.setTitle(syncLogPO.getTitle());
                        logPO.setUrl(syncLogPO.getUrl());
                        logPO.setTaskNum(Integer.valueOf(logPO.getTaskNum() + 1));
                        logPO.setUpdateTime(new Date());
                        this.syncLogMapper.updateByPrimaryKey(logPO);
                        continue;
                    }
                    this.syncLogMapper.insertSelective(syncLogPO);
                    BeanUtils.copyProperties((Object)syncLogPO, (Object)syncLogBO);
                    this.redisHelper.lSet("spider_receiveSkuInfo", (Object)syncLogBO);
                }
            }
        }
        catch (Exception e) {
            log.error("redis set\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp queryGoodByKeyword(QueryGoodByKeywordReqBO reqBO) {
        try {
            this.redisHelper.lSet("spider_keyword", (Object)reqBO);
        }
        catch (Exception e) {
            log.error("redis set\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public RspList<CategoryBO> queryNewCategory() {
        ArrayList<GoodsBO> goodsBOList = new ArrayList<GoodsBO>();
        try {
            List categoryPOList = this.categoryMapper.selectNewCategory();
            if (CollectionUtils.isNotEmpty((Collection)categoryPOList)) {
                for (CategoryPO categoryPO : categoryPOList) {
                    GoodsBO goodsBO = GoodsBO.builder().build();
                    BeanUtils.copyProperties((Object)categoryPO, (Object)goodsBO);
                    goodsBOList.add(goodsBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65b0\u5206\u7c7b\u5f02\u5e38", (Throwable)e);
        }
        return BaseRspUtils.createSuccessRspList(goodsBOList);
    }

    public List<String> querySpiderLog(SpiderParameterBO reqBO) {
        String mall = reqBO.getMall();
        List categoryIdList = reqBO.getCategoryIdList();
        List<Object> allCategoryIdList = new ArrayList();
        this.spiderLogMapper.deleteBySign(mall);
        if (CollectionUtils.isEmpty((Collection)categoryIdList)) {
            List categoryList;
            SpiderLogPO spiderLogPO = this.spiderLogMapper.selectBySignAndType(mall, reqBO.getExtraUrlParam());
            if (spiderLogPO != null && spiderLogPO.getCategoryId() != null) {
                if (spiderLogPO.getSpiderType().equals("2") && !spiderLogPO.getCurrentPage().equals(spiderLogPO.getTotalPage())) {
                    allCategoryIdList.add(spiderLogPO.getCategoryId());
                }
                List list = this.categoryMapper.selectCategoryIdListById(mall, spiderLogPO.getCategoryId());
                allCategoryIdList.addAll(list);
            }
            if (CollectionUtils.isEmpty(allCategoryIdList) && CollectionUtils.isNotEmpty((Collection)(categoryList = this.categoryMapper.selectCategoryList(Integer.valueOf(3), mall)))) {
                allCategoryIdList = categoryList.stream().map(CategoryPO::getCategoryId).collect(Collectors.toList());
            }
        } else {
            allCategoryIdList = categoryIdList;
        }
        return allCategoryIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIP() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.redisHelper.get("instanceId") == null) {
                    this.redisHelper.set("instanceId", (Object)this.instanceId, 300L);
                    DefaultAcsClient client = AliApiUtil.createClient();
                    SpiderEipPO eipPO = this.spiderEipMapper.selectByPrimaryKey(this.instanceId);
                    if (eipPO != null) {
                        String oldEIP = eipPO.getEip();
                        boolean flag = AliApiUtil.describeEipAddresses(client, oldEIP);
                        if (flag) {
                            AliApiUtil.unassociateEipAddres(client, oldEIP);
                            TimeUnit.SECONDS.sleep(5L);
                        }
                        AllocateEipAddressResponse response = AliApiUtil.allocateEipAddress(client);
                        String newEIp = response.getAllocationId();
                        String newIPAdress = response.getEipAddress();
                        AliApiUtil.associateEipAddress(client, newEIp);
                        SpiderEipPO newEipPO = new SpiderEipPO();
                        newEipPO.setCreateTime(new Date());
                        newEipPO.setEcsId(this.instanceId);
                        newEipPO.setEip(newEIp);
                        newEipPO.setEipAdress(newIPAdress);
                        this.spiderEipMapper.insertSelective(newEipPO);
                        AliApiUtil.releaseEipAddress(client, oldEIP);
                        eipPO.setIsDelete(Byte.valueOf((byte)1));
                        eipPO.setUpdateTime(new Date());
                        this.spiderEipMapper.updateByPrimaryKeySelective(eipPO);
                    } else {
                        log.info("EIp\u914d\u7f6e\u6709\u8bef");
                    }
                } else {
                    log.info("\u5176\u4ed6\u7ebf\u7a0b\u5207\u6362ip");
                }
            }
        }
        catch (Exception e) {
            log.error("\u5207\u6362ip\u5f02\u5e38", (Throwable)e);
            this.redisHelper.del(new String[]{"instanceId"});
        }
    }

    public void spiderDesc(SpiderSyncLogBO syncLogBO) {
        String skuId = syncLogBO.getGoodsNo();
        String url = syncLogBO.getUrl();
        String title = syncLogBO.getTitle();
        GoodsBO goodsBO = GoodsBO.builder().goodsNo(skuId).prefix(syncLogBO.getSign()).url(url).title(title).build();
        SpiderSyncLogPO syncLogPO = SpiderSyncLogPO.builder().build();
        BeanUtils.copyProperties((Object)syncLogBO, (Object)syncLogPO);
        try {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.commodityInformationServiceFactory.climbProductDetailsByGoodsNo(goodsBO);
                syncLogPO.setSpiderState(Integer.valueOf(1));
            } else {
                syncLogPO.setSpiderState(Integer.valueOf(8));
            }
        }
        catch (Exception e) {
            log.error("\u57ce\u722c\u53d6\u8be6\u60c5\u5931\u8d25skuId:{}", (Object)skuId, (Object)e);
            syncLogPO.setSpiderState(Integer.valueOf(0));
            syncLogPO.setErrorMsg(e.getMessage());
        }
        try {
            syncLogPO.setUpdateTime(new Date());
            this.syncLogMapper.updateByPrimaryKeySelective(syncLogPO);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u4fe1\u606f\u5f02\u5e38", (Object)syncLogPO);
        }
    }

    public Rsp saveRedisTask(GoodsNoListReqBO goodsNoListReqBO) {
        List pids = goodsNoListReqBO.getPids();
        if (CollectionUtils.isEmpty((Collection)pids)) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            List goodsList = this.syncLogMapper.selectByPids(MallType.JD.getCode(), pids);
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                for (SpiderSyncLogPO syncLogPO : goodsList) {
                    SpiderSyncLogBO syncLogBO = new SpiderSyncLogBO();
                    BeanUtils.copyProperties((Object)syncLogPO, (Object)syncLogBO);
                    this.redisHelper.lSet("spider_receiveSkuInfo", (Object)syncLogBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u722c\u53d6\u5931\u8d25reqBO:" + goodsNoListReqBO, (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u91cd\u65b0\u52a0\u5165\u6267\u884c\u961f\u5217\u6210\u529f");
        return BaseRspUtils.createSuccessRsp((Object)"\u91cd\u65b0\u52a0\u5165\u6267\u884c\u961f\u5217\u6210\u529f");
    }

    public Resp queryTaskList(QueryTaskListReqBO reqBO) {
        Resp resp = new Resp();
        try {
            Integer page = reqBO.getPageNo();
            Integer limit = reqBO.getPageSize();
            if (page == null || page < 0 || limit == null || limit < 0) {
                page = 1;
                limit = 10;
            }
            PageHelper.startPage((int)page, (int)limit);
            List taskListRspBOS = this.syncLogMapper.selectTaskList(reqBO);
            int taskNum = this.syncLogMapper.selectTaskSum(reqBO);
            PageInfo pageInfo = new PageInfo(taskListRspBOS);
            if (pageInfo != null) {
                resp.setRecordsTotal(pageInfo.getTotal());
                resp.setTaskNum(Integer.valueOf(taskNum));
            }
            resp.setData((Object)taskListRspBOS);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            resp.setRespCode("8888");
            resp.setRespDesc("\u67e5\u8be2\u5f02\u5e38");
        }
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return resp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public Rsp saveGoodsInfo(SaveGoodsInfoReqBO reqBO) {
        if (reqBO.getPid() == null || !StringUtils.isNotEmpty((CharSequence)reqBO.getSpiderPrice()) && !StringUtils.isNotEmpty((CharSequence)reqBO.getSpiderTitle()) && !StringUtils.isNotEmpty((CharSequence)reqBO.getComment())) return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            SpiderSyncLogPO logPO = this.syncLogMapper.selectByPrimaryKey(reqBO.getPid());
            String skuId = "";
            if (logPO == null) return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
            Pattern pattern = Pattern.compile("[^0-9]+");
            Matcher matcher = pattern.matcher(logPO.getUrl());
            skuId = matcher.replaceAll("").trim();
            Goods goods = new Goods();
            goods.setSkuId(skuId);
            goods.setGoodsNo(logPO.getGoodsNo());
            goods.setUrl(logPO.getUrl());
            goods.setCategoryId("-1");
            goods.setTitle(reqBO.getSpiderTitle());
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getSpiderPrice())) {
                goods.setPrice(new BigDecimal(reqBO.getSpiderPrice()));
            }
            goods.setSkuState("1");
            goods.setPrefix(logPO.getSign());
            GoodsDetailsWithBLOBs details = new GoodsDetailsWithBLOBs();
            details.setGoodsNo(logPO.getGoodsNo());
            details.setSkuId(goods.getSkuId());
            details.setComment(reqBO.getComment());
            details.setSkuAttrNames("\u5546\u54c1\u540d\u79f0");
            details.setSkuSaleAttrNames("{}");
            details.setPrefix(logPO.getSign());
            if (this.goodsMapper.selectByPrimaryKey(goods) != null) {
                goods.setUpdated(new Date());
                this.goodsMapper.updateByPrimaryKeySelective(goods);
            } else {
                goods.setCreated(new Date());
                goods.setUpdated(new Date());
                this.goodsMapper.insertSelective(goods);
            }
            if (this.goodsDetailsMapper.selectByPrimaryKey((GoodsDetails)details) == null) {
                details.setCreated(new Date());
                details.setUpdated(new Date());
                this.goodsDetailsMapper.insertSelective(details);
            } else {
                details.setUpdated(new Date());
                this.goodsDetailsMapper.updateByPrimaryKeySelective(details);
            }
            logPO.setSpiderState(Integer.valueOf(1));
            logPO.setUpdateTime(new Date());
            this.syncLogMapper.updateByPrimaryKey(logPO);
            return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public Rsp countTaskRedis() {
        CountTaskRedisRspBO rspBO = new CountTaskRedisRspBO();
        Long size = this.redisHelper.lGetListSize("spider_receiveSkuInfo");
        rspBO.setCount(size);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp queryTaskByTime(QueryTaskByTimeReqBO reqBO) {
        List skuIds = new ArrayList();
        try {
            String sign = reqBO.getPoolName();
            String taskTime = reqBO.getTaskTime();
            if (!StringUtils.isNotEmpty((CharSequence)sign) || !StringUtils.isNotEmpty((CharSequence)taskTime)) {
                return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u6709\u8bef");
            }
            skuIds = this.syncLogMapper.selectByTime(sign, taskTime);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return BaseRspUtils.createSuccessRsp(skuIds);
    }

    public Rsp spiderErrorGoodsDetail() {
        try {
            for (MallType value : MallType.values()) {
                List goodsList = this.syncLogMapper.selectByState(value.getCode(), new Date());
                if (!CollectionUtils.isNotEmpty((Collection)goodsList)) continue;
                for (SpiderSyncLogPO syncLogPO : goodsList) {
                    SpiderSyncLogBO syncLogBO = new SpiderSyncLogBO();
                    BeanUtils.copyProperties((Object)syncLogPO, (Object)syncLogBO);
                    this.spiderDesc(syncLogBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u722c\u53d6\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u722c\u53d6\u7ed3\u675f");
        return BaseRspUtils.createSuccessRsp((Object)"\u5546\u57ce\u722c\u53d6\u6210\u529f");
    }
}

