/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.ProxyService;
import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.api.bo.QueryGoodByKeywordReqBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.api.bo.SpiderSyncLogBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.mapper.SpiderSyncLogMapper;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CategoryJobHandler {
    private static final Logger log = LoggerFactory.getLogger(CategoryJobHandler.class);
    @Autowired
    private RedisHelper redisHelper;
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;
    @Autowired
    private SpiderService spiderService;
    @Autowired
    private SpiderSyncLogMapper syncLogMapper;
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    @Resource
    private ProxyService proxyService;

    public CategoryJobHandler(CommodityInformationServiceFactory commodityInformationServiceFactory) {
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
    }

    @XxlJob(value="spiderCategoryJob")
    public Rsp addCategory() {
        String[] malls;
        int total = XxlJobHelper.getShardTotal();
        int index = XxlJobHelper.getShardIndex();
        String param = XxlJobHelper.getJobParam();
        if (StringUtils.isNotEmpty((CharSequence)param) && (malls = param.split(",")).length > 0) {
            for (int i = 0; i < malls.length; ++i) {
                if (i % total != index) continue;
                String mall = malls[i];
                boolean cont = MallType.isExist(mall);
                if (BooleanUtils.isFalse((Boolean)cont)) {
                    return BaseRspUtils.createErrorRsp((String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
                }
                try {
                    this.commodityInformationServiceFactory.addCategory(mall);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u5546\u57ce\u5206\u7c7b\u722c\u53d6\u5931\u8d25", (Throwable)e);
                    return BaseRspUtils.createErrorRsp((String)e.getMessage());
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)param, (String)"\u5546\u57ce\u5206\u7c7b\u722c\u53d6\u6210\u529f");
    }

    @XxlJob(value="spiderGoodsJob")
    public Rsp spiderGoods() {
        String param;
        block5: {
            param = XxlJobHelper.getJobParam();
            try {
                if (StringUtils.isNotEmpty((CharSequence)param)) {
                    int total = XxlJobHelper.getShardTotal();
                    int index = XxlJobHelper.getShardIndex();
                    JSONObject jsonObject = JSON.parseObject((String)param);
                    String mall = jsonObject.getString("mall");
                    JSONArray categoryIdList = jsonObject.getJSONArray("categoryIdList");
                    SpiderParameterBO parameter = new SpiderParameterBO();
                    ArrayList categoryList = new ArrayList();
                    SpiderParameterBO spiderBO = new SpiderParameterBO();
                    spiderBO.setMall(mall);
                    spiderBO.setExtraUrlParam("2");
                    spiderBO.setCategoryIdList((List)categoryIdList);
                    List allCategoryIdList = this.spiderService.querySpiderLog(spiderBO);
                    if (CollectionUtils.isNotEmpty((Collection)allCategoryIdList)) {
                        MallState.updateState(mall, false);
                        for (int i = 0; i < allCategoryIdList.size(); ++i) {
                            ArrayList<String> queryCategoryList = new ArrayList<String>();
                            String categoryId = (String)allCategoryIdList.get(i);
                            queryCategoryList.add(categoryId);
                            if (i % total != index) continue;
                            parameter.setMall(mall);
                            parameter.setCategoryIdList(queryCategoryList);
                            this.commodityInformationServiceFactory.climbCommodityTabulate(parameter);
                        }
                    }
                    break block5;
                }
                return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u4e3a\u7a7a");
            }
            catch (Exception e) {
                log.error("\u5546\u57ce\u5546\u54c1\u5217\u8868\u722c\u53d6\u5931\u8d25", (Throwable)e);
                return BaseRspUtils.createErrorRsp((String)e.getMessage());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)param, (String)"\u5546\u57ce\u5546\u54c1\u5217\u8868\u722c\u53d6\u6210\u529f");
    }

    @XxlJob(value="spiderGoodsDetailJob")
    public Rsp spiderGoodsDetail() {
        String param = XxlJobHelper.getJobParam();
        try {
            if (StringUtils.isNotEmpty((CharSequence)param)) {
                int total = XxlJobHelper.getShardTotal();
                int index = XxlJobHelper.getShardIndex();
                JSONObject jsonObject = JSON.parseObject((String)param);
                String mall = jsonObject.getString("mall");
                JSONArray categoryIdList = jsonObject.getJSONArray("categoryIdList");
                SpiderParameterBO spiderBO = new SpiderParameterBO();
                spiderBO.setMall(mall);
                spiderBO.setExtraUrlParam("3");
                spiderBO.setCategoryIdList((List)categoryIdList);
                List allCategoryIdList = this.spiderService.querySpiderLog(spiderBO);
                if (CollectionUtils.isNotEmpty((Collection)allCategoryIdList)) {
                    MallState.updateState(mall, false);
                    log.info("\u6839\u636ecategoryIdList\u722c\u53d6\u8be6\u60c5\u6570\u636e\u5f00\u59cb");
                    for (int i = 0; i < allCategoryIdList.size(); ++i) {
                        String categoryId = (String)allCategoryIdList.get(i);
                        if (i % total != index) continue;
                        this.commodityInformationServiceFactory.climbProductDetailsWithCategoryId(mall, categoryId);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u5546\u54c1\u8be6\u60c5\u722c\u53d6\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)param, (String)"\u5546\u57ce\u5546\u54c1\u8be6\u60c5\u722c\u53d6\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="spiderKeywordJob")
    public Rsp spiderKeywordJob() {
        String param = XxlJobHelper.getJobParam();
        int total = XxlJobHelper.getShardTotal();
        int index = XxlJobHelper.getShardIndex();
        QueryGoodByKeywordReqBO reqBO = null;
        try {
            Object object;
            if (StringUtils.isNotEmpty((CharSequence)param) && (object = this.redisHelper.lLPop("spider_keyword")) != null) {
                reqBO = (QueryGoodByKeywordReqBO)object;
                this.redisHelper.lSet("spider_keyword2", (Object)reqBO);
                String[] malls = param.split(",");
                for (int i = 0; i < malls.length; ++i) {
                    if (i % total != index) continue;
                    Future<String> future = this.commodityInformationServiceFactory.climbProductDetailsByKeyword(malls[i], reqBO.getKeyword());
                }
                log.info("\u5173\u952e\u8bcd\u722c\u53d6\u6210\u529f:" + reqBO.getKeyword());
            }
        }
        catch (Exception e) {
            Rsp rsp;
            try {
                this.redisHelper.lSet("spider_keyword", reqBO);
                log.error("\u5546\u57ce\u5173\u952e\u8bcd\u722c\u53d6\u5931\u8d25reqBO" + reqBO, (Throwable)e);
                rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            }
            catch (Throwable throwable) {
                log.info("\u79fb\u9664list2\u4e2d\u6570\u636e");
                this.redisHelper.lRemove("spider_keyword2", 0L, reqBO);
                throw throwable;
            }
            log.info("\u79fb\u9664list2\u4e2d\u6570\u636e");
            this.redisHelper.lRemove("spider_keyword2", 0L, (Object)reqBO);
            return rsp;
        }
        log.info("\u79fb\u9664list2\u4e2d\u6570\u636e");
        this.redisHelper.lRemove("spider_keyword2", 0L, reqBO);
        return BaseRspUtils.createSuccessRsp((Object)"\u5546\u57ce\u5173\u952e\u8bcd\u722c\u53d6\u6210\u529f");
    }

    @XxlJob(value="spiderGoodsDeatilByGoodsNoJob")
    public Rsp spiderGoodsDetailByGoodsNo() {
        SpiderSyncLogBO reqBO = null;
        try {
            Object object = this.redisHelper.lLPop("spider_receiveSkuInfo");
            log.info("\u83b7\u53d6\u722c\u53d6\u6570\u636e");
            if (object != null) {
                reqBO = (SpiderSyncLogBO)object;
                if (reqBO != null) {
                    this.spiderService.spiderDesc(reqBO);
                }
                log.info("\u722c\u53d6\u6210\u529f:{}" + object);
            }
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u722c\u53d6\u5931\u8d25reqBO" + reqBO, (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u722c\u53d6\u7ed3\u675f");
        return BaseRspUtils.createSuccessRsp((Object)"\u5546\u57ce\u722c\u53d6\u6210\u529f");
    }

    @XxlJob(value="spiderErrorGoodsDetail")
    public Rsp spiderErrorGoodsDetail() {
        return this.spiderService.spiderErrorGoodsDetail();
    }
}

