/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.web;

import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spiderCache"})
public class SpiderCacheController {
    private static final Logger log = LoggerFactory.getLogger(SpiderCacheController.class);
    private final CacheInfoServiceImpl cacheInfoServiceImpl;

    public SpiderCacheController(CacheInfoServiceImpl cacheInfoServiceImpl) {
        this.cacheInfoServiceImpl = cacheInfoServiceImpl;
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/addDet"})
    public Rsp addCache(@RequestBody SpiderParameterBO spiderParameterBO) {
        String mall = spiderParameterBO.getMall();
        if (!RedisCacheKey.isExist(mall)) {
            return BaseRspUtils.createErrorRsp((Object)200, (String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        this.cacheInfoServiceImpl.addDet(RedisCacheKey.fromMall(mall), spiderParameterBO.getCategoryIdList());
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/getDet"})
    public Rsp getCache(@RequestBody SpiderParameterBO spiderParameterBO) {
        String mall = spiderParameterBO.getMall();
        if (!RedisCacheKey.isExist(mall)) {
            return BaseRspUtils.createErrorRsp((Object)200, (String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List<Goods> goodsList = this.cacheInfoServiceImpl.getGoodsCache(RedisCacheKey.fromMall(mall), -1L);
        if (CollectionUtils.isEmpty(goodsList)) {
            System.out.println(goodsList.size());
        }
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/addLi"})
    public Rsp addLiCache(@RequestBody SpiderParameterBO spiderParameterBO) {
        String mall = spiderParameterBO.getMall();
        if (!RedisCacheKey.isExist(mall)) {
            return BaseRspUtils.createErrorRsp((Object)200, (String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        this.cacheInfoServiceImpl.addLi(RedisCacheKey.fromMall(mall), spiderParameterBO.getCategoryIdList());
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/getLi"})
    public Rsp getLiCache(@RequestBody SpiderParameterBO spiderParameterBO) {
        String mall = spiderParameterBO.getMall();
        if (!RedisCacheKey.isExist(mall)) {
            return BaseRspUtils.createErrorRsp((Object)200, (String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List<CategoryPO> liCache = this.cacheInfoServiceImpl.getGoodsLiCache(RedisCacheKey.fromMall(mall), -1L);
        if (liCache != null) {
            System.out.println();
        }
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f");
    }
}

