/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.web;

import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.RedisService;
import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.api.bo.CategoryBO;
import com.tydic.nicc.spider.api.bo.DataSkuInfo;
import com.tydic.nicc.spider.api.bo.GoodsNoListReqBO;
import com.tydic.nicc.spider.api.bo.KeywordReqBO;
import com.tydic.nicc.spider.api.bo.QueryGoodByKeywordReqBO;
import com.tydic.nicc.spider.api.bo.QueryTaskByTimeReqBO;
import com.tydic.nicc.spider.api.bo.QueryTaskListReqBO;
import com.tydic.nicc.spider.api.bo.Resp;
import com.tydic.nicc.spider.api.bo.SaveGoodsInfoReqBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.api.bo.SpiderSyncLogBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spider"})
public class SpiderController {
    private static final Logger log = LoggerFactory.getLogger(SpiderController.class);
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;
    @Resource
    private CategoryMapper categoryMapper;
    @Autowired
    private RedisHelper redisHelper;
    @Autowired
    private SpiderService spiderService;
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    @Resource
    private RedisService redisService;
    @Value(value="${nicc-plugin.spider.thread-num}")
    private int threadNum;

    public SpiderController(CommodityInformationServiceFactory commodityInformationServiceFactory) {
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
    }

    @PostMapping(value={"/addOneLevelCategory"})
    public Rsp addOneLevelCategory(@RequestBody SpiderBO spiderBO) {
        String mall = spiderBO.getMall();
        boolean cont = MallType.isExist(mall);
        if (BooleanUtils.isFalse((Boolean)cont)) {
            return BaseRspUtils.createErrorRsp((String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        try {
            this.commodityInformationServiceFactory.addCategory(mall);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((Object)500, (String)"\u5546\u57ce\u5206\u7c7b\u722c\u53d6\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)spiderBO.getMall(), (String)"\u5546\u57ce\u5206\u7c7b\u722c\u53d6\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/climbCommodityTabulate"})
    public Rsp climbCommodityTabulate(@RequestBody SpiderParameterBO parameter) {
        String mall = parameter.getMall();
        boolean cont = MallType.isExist(mall);
        if (BooleanUtils.isFalse((Boolean)cont)) {
            return BaseRspUtils.createErrorRsp((String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        MallState.updateState(mall, false);
        try {
            List categoryIdList = parameter.getCategoryIdList();
            List urlList = parameter.getUrlList();
            if (CollectionUtils.isNotEmpty((Collection)categoryIdList) || CollectionUtils.isNotEmpty((Collection)urlList)) {
                log.info("\u6839\u636ecategoryIdList \u6216\u8005 urlList \u722c\u53d6\u5217\u8868\u6570\u636e");
                this.commodityInformationServiceFactory.climbCommodityTabulate(parameter);
            } else {
                List categoryList = this.categoryMapper.selectCategoryList(Integer.valueOf(3), mall);
                log.info("\u722c\u53d6\u5546\u57ce{}\u4e2a\u5206\u7c7b\u5217\u8868\u6570\u636e", (Object)categoryList.size());
                if (CollectionUtils.isNotEmpty((Collection)categoryList)) {
                    List allCategoryIdList = categoryList.stream().map(CategoryPO::getCategoryId).collect(Collectors.toList());
                    List allUrlList = categoryList.stream().map(CategoryPO::getUrl).collect(Collectors.toList());
                    parameter.setCategoryIdList(allCategoryIdList);
                    parameter.setUrlList(allUrlList);
                    this.commodityInformationServiceFactory.climbCommodityTabulate(parameter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((Object)500, (String)"\u5217\u8868\u4fe1\u606f\u722c\u53d6\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u5217\u8868\u4fe1\u606f\u722c\u53d6\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/climbProductInfo"})
    public Rsp climbProductInfo(@RequestBody SpiderParameterBO parameter) {
        String mall = parameter.getMall();
        boolean cont = MallType.isExist(mall);
        if (BooleanUtils.isFalse((Boolean)cont)) {
            return BaseRspUtils.createErrorRsp((String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        MallState.updateState(mall, false);
        try {
            List categoryIdList = parameter.getCategoryIdList();
            List urlList = parameter.getUrlList();
            if (CollectionUtils.isNotEmpty((Collection)categoryIdList)) {
                log.info("\u6839\u636ecategoryIdList\u722c\u53d6\u8be6\u60c5\u6570\u636e\u5f00\u59cb");
                for (String categoryId : categoryIdList) {
                    this.commodityInformationServiceFactory.climbProductDetailsWithCategoryId(mall, categoryId);
                }
            } else if (CollectionUtils.isNotEmpty((Collection)urlList)) {
                log.info("\u6839\u636eurlList \u722c\u53d6\u8be6\u60c5\u6570\u636e\u5f00\u59cb");
                for (String url : urlList) {
                    CategoryPO categoryPO = this.categoryMapper.selectCategoryIdByUrl(url);
                    if (Objects.isNull(categoryPO)) continue;
                    this.commodityInformationServiceFactory.climbProductDetailsWithCategoryId(mall, categoryPO.getCategoryId());
                }
            } else {
                List allCategoryIdList = this.categoryMapper.selectCategoryIdList(mall);
                log.info("\u722c\u53d6\u5546\u57ce{}\u4e2a\u5206\u7c7b\u8be6\u60c5\u6570\u636e\u5f00\u59cb", (Object)allCategoryIdList.size());
                if (CollectionUtils.isNotEmpty((Collection)allCategoryIdList)) {
                    for (String categoryId : allCategoryIdList) {
                        this.commodityInformationServiceFactory.climbProductDetailsWithCategoryId(mall, categoryId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((Object)500, (String)"\u8be6\u60c5\u4fe1\u606f\u4fe1\u606f\u722c\u53d6\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)mall, (String)"\u5206\u7c7b\u8be6\u60c5\u4fe1\u606f\u722c\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/exitGracefully/{mall}"})
    public Rsp EndClimbing(@PathVariable String mall) {
        boolean cont = MallType.isExist(mall);
        if (BooleanUtils.isFalse((Boolean)cont)) {
            return BaseRspUtils.createErrorRsp((String)"\u5546\u57ce\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        MallState.updateState(mall, true);
        return BaseRspUtils.createSuccessRsp((Object)(mall + "\u5546\u57ce\u5df2\u7ecf\u505c\u6b62\u722c\u53d6"));
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/insertData"})
    public Rsp insertData(@RequestBody SpiderParameterBO parameter) {
        this.redisService.insertData(parameter.getMall());
        return BaseRspUtils.createSuccessRsp((Object)(parameter.getMall() + "\u5546\u57ce\u5df2\u7ecf\u5c06url\u5b58\u5165redis"));
    }

    @MethodParamVerifyEnable
    @PostMapping(value={"/climbProductDetails"})
    public Rsp climbProductDetails(@RequestBody SpiderParameterBO parameter) {
        int num = 1 + this.threadNum;
        try {
            CompletableFuture future = new CompletableFuture();
            for (int i = 0; i < num; ++i) {
                CompletableFuture<String> task = CompletableFuture.supplyAsync(() -> {
                    String result = this.commodityInformationServiceFactory.climbProductDetails(parameter.getMall());
                    return result;
                });
                task.whenComplete((result, ex) -> {
                    if (ex == null) {
                        future.complete("Async method executed successfully.");
                        log.info("Async method executed successfully.");
                    } else {
                        future.completeExceptionally((Throwable)ex);
                        log.info(ex.getMessage());
                    }
                });
                boolean condition = task.isDone();
                if (!condition) continue;
                String executionResult = task.get();
                log.info(executionResult);
            }
            return BaseRspUtils.createSuccessRsp((Object)(parameter.getMall() + "\u5546\u57ce\u8be6\u60c5\u5df2\u7ecf\u722c\u53d6\u5b8c\u6bd5"));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/queryProductByKeyword"})
    public Rsp queryProductByKeyword(@RequestBody KeywordReqBO keywordReqBO) {
        List keywordReqBOList = keywordReqBO.getKeywordReqBOList();
        if (CollectionUtils.isNotEmpty((Collection)keywordReqBOList)) {
            for (QueryGoodByKeywordReqBO reqBO : keywordReqBOList) {
                this.spiderService.queryGoodByKeyword(reqBO);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    @PostMapping(value={"/receiveSkuInfo"})
    public Rsp receiveSkuInfo(@RequestBody DataSkuInfo reqBO) {
        return this.spiderService.receiveSkuInfo(reqBO);
    }

    @PostMapping(value={"/queryNewCategory"})
    public RspList<CategoryBO> queryNewCategory() {
        return this.spiderService.queryNewCategory();
    }

    @PostMapping(value={"/spiderGoodsDetailByGoodsNo"})
    public Rsp spiderGoodsDetailByGoodsNo() {
        SpiderSyncLogBO reqBO = null;
        try {
            Object object = this.redisHelper.lLPop("spider_receiveSkuInfo");
            log.info("\u83b7\u53d6\u722c\u53d6\u6570\u636e");
            if (object != null) {
                reqBO = (SpiderSyncLogBO)object;
                if (reqBO != null) {
                    this.spiderService.spiderDesc(reqBO);
                }
                log.info("\u722c\u53d6\u6210\u529f:{}" + object);
            }
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u722c\u53d6\u5931\u8d25reqBO" + reqBO, (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u722c\u53d6\u7ed3\u675f");
        return BaseRspUtils.createSuccessRsp((Object)"\u5546\u57ce\u722c\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/spiderErrorGoodsDetail"})
    public Rsp spiderErrorGoodsDetail() {
        return this.spiderService.spiderErrorGoodsDetail();
    }

    @PostMapping(value={"/saveRedisTask"})
    public Rsp saveRedisTask(@RequestBody GoodsNoListReqBO reqBO) {
        return this.spiderService.saveRedisTask(reqBO);
    }

    @PostMapping(value={"/queryTaskList"})
    public Resp queryTaskList(@RequestBody QueryTaskListReqBO reqBO) {
        return this.spiderService.queryTaskList(reqBO);
    }

    @PostMapping(value={"/saveGoodsInfo"})
    public Rsp saveGoodsInfo(@RequestBody SaveGoodsInfoReqBO reqBO) {
        return this.spiderService.saveGoodsInfo(reqBO);
    }

    @PostMapping(value={"/countTaskRedis"})
    public Rsp countTaskRedis() {
        return this.spiderService.countTaskRedis();
    }

    @PostMapping(value={"/queryTaskByTime"})
    public Rsp queryTaskByTime(@RequestBody QueryTaskByTimeReqBO reqBO) {
        return this.spiderService.queryTaskByTime(reqBO);
    }
}

