/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom.utils;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.nicc.unicom.utils.SystemPropertiesConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonTool {
    private static SystemPropertiesConfig systemPropertiesConfig;
    public static final String format1 = "yyyy-MM-dd HH:mm:ss";
    public static final String format2 = "yyyy-MM-dd";
    public static final String format3 = "yyyy-MM-dd HH:mm:00.000";
    public static final String format4 = "HH:mm:ss";
    public static final String SEP_STR = "/";

    @Autowired
    public void init(SystemPropertiesConfig systemPropertiesConfig) {
        CommonTool.systemPropertiesConfig = systemPropertiesConfig;
    }

    public static boolean strIsEmpty(String str) {
        if (str == null) {
            return true;
        }
        if ("".equals(str)) {
            return true;
        }
        if (str == "") {
            return true;
        }
        if (str.length() < 1) {
            return true;
        }
        return "undefined".equals(str);
    }

    public static boolean strIsEmpty(String ... value) {
        for (String str : value) {
            if (!CommonTool.strIsEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String formatDate(Date date) {
        return CommonTool.dateToStr(date, format1);
    }

    public static String formatDateYear(Date date) {
        return CommonTool.dateToStr(date, format2);
    }

    public static Date getAfterDate(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static long getPrimaryKey() {
        Sequence sequence = Sequence.getInstance();
        return sequence.nextId();
    }

    public static <T> List<T> ListSplit(List<T> list, int row, int page) {
        List<T> newList = null;
        int total = list.size();
        newList = list.subList(row * (page - 1), row * page > total ? total : row * page);
        return newList;
    }

    public static int getTotal(int total, int pageSize) {
        int c = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        return c;
    }

    public static String getUuid() {
        UUID uuid = UUID.randomUUID();
        String result = uuid.toString().replaceAll("-", "");
        return result;
    }

    public static String concatFilePath(String path1, String path2) {
        if (path1.endsWith(SEP_STR) && path2.startsWith(SEP_STR)) {
            return path1 + path2.substring(1, path2.length());
        }
        if (!path1.endsWith(SEP_STR) && !path2.startsWith(SEP_STR)) {
            return path1 + SEP_STR + path2;
        }
        return path1 + path2;
    }

    public static String getIvrPath(String type, String fileName) {
        String head = "";
        switch (type) {
            case "0": {
                head = SEP_STR + systemPropertiesConfig.getAl() + SEP_STR;
                break;
            }
            case "1": {
                head = SEP_STR + systemPropertiesConfig.getBd() + SEP_STR;
                break;
            }
            case "2": {
                head = SEP_STR + systemPropertiesConfig.getXf() + SEP_STR;
            }
        }
        return head + fileName;
    }

    public static String dateToStr(Date date) {
        return CommonTool.dateToStr(date, format2);
    }

    public static String dateToStr2(Date date) {
        return CommonTool.dateToStr(date, "yyyy_MM_dd");
    }

    public static Date strToDate(String str) {
        if (CommonTool.strIsEmpty(str)) {
            return null;
        }
        return CommonTool.strToDate(str, format2);
    }

    public static Date strToTime(String str) {
        if (CommonTool.strIsEmpty(str)) {
            return null;
        }
        return CommonTool.strToDate(str, format4);
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String dateToStr(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String str = dateFormat.format(date);
        return str;
    }

    public static Date strToDate(String str, String format) {
        if (CommonTool.strIsEmpty(str)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getTPoint(Date time) {
        String str;
        Date time1;
        if (time == null) {
            time = new Date();
        }
        if ((time1 = CommonTool.strToDate(str = CommonTool.dateToStr(time, format3), format3)) == null) {
            time.setSeconds(0);
        } else {
            time = time1;
        }
        time.setMinutes(time.getMinutes() / 5 * 5);
        return time;
    }

    public static Date getTPoint(Date time, int duration) {
        String str;
        Date time1;
        if (time == null) {
            time = new Date();
        }
        if ((time1 = CommonTool.strToDate(str = CommonTool.dateToStr(time, format3), format3)) == null) {
            time.setSeconds(0);
        } else {
            time = time1;
        }
        time.setMinutes(time.getMinutes() / duration * duration);
        return time;
    }

    public static Date getAfterTime(Date time, int minutes) {
        if (time == null) {
            return null;
        }
        Date d = new Date(time.getTime() + (long)(60000 * minutes));
        return d;
    }

    public static Date getAfterTimeByS(Date time, int s) {
        if (time == null) {
            return null;
        }
        Date d = new Date(time.getTime() + (long)(1000 * s));
        return d;
    }

    public static void main(String[] args) {
    }
}

