/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnUtil {
    private static final Logger log = LoggerFactory.getLogger(ConnUtil.class);

    public static String urlEncode(String str) {
        String result = null;
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getResponseString(HttpURLConnection conn) throws Exception {
        return new String(ConnUtil.getResponseBytes(conn));
    }

    public static byte[] getResponseBytes(HttpURLConnection conn) throws Exception {
        int responseCode = conn.getResponseCode();
        InputStream inputStream = conn.getInputStream();
        if (responseCode != 200) {
            log.error("http \u8bf7\u6c42\u8fd4\u56de\u7684\u72b6\u6001\u7801\u9519\u8bef\uff0c\u671f\u671b200\uff0c \u5f53\u524d\u662f " + responseCode);
            if (responseCode == 401) {
                log.error("\u53ef\u80fd\u662fappkey appSecret \u586b\u9519");
            }
            log.error("response headers" + conn.getHeaderFields());
            if (inputStream == null) {
                inputStream = conn.getErrorStream();
            }
            byte[] result = ConnUtil.getInputStreamContent(inputStream);
            log.info(new String(result));
            throw new Exception("http response code is" + responseCode);
        }
        byte[] result = ConnUtil.getInputStreamContent(inputStream);
        return result;
    }

    public static byte[] getInputStreamContent(InputStream is) throws IOException {
        byte[] b = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int len = 0;
        while ((len = is.read(b)) != -1) {
            byteArrayOutputStream.write(b, 0, len);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

