/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadExcelAboutUser(HttpServletResponse response, String fileName, List<String> columnList, List<List<String>> dataList) {
        ServletOutputStream os = null;
        ExcelUtil.setResponseHeader(response, fileName);
        try {
            os = response.getOutputStream();
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            int excelRow = 0;
            HSSFRow titleRow = sheet.createRow(excelRow++);
            for (int i = 0; i < columnList.size(); ++i) {
                Cell cell = titleRow.createCell(i);
                cell.setCellValue(columnList.get(i));
            }
            if (dataList != null && dataList.size() > 0) {
                int count = 1;
                for (int i = 0; i < dataList.size(); ++i) {
                    HSSFRow dataRow = sheet.createRow(excelRow++);
                    for (int j = -1; j < dataList.get(0).size(); ++j) {
                        Cell cell = dataRow.createCell(j + 1);
                        if (j == -1) {
                            cell.setCellValue((double)count++);
                            continue;
                        }
                        cell.setCellValue(dataList.get(i).get(j));
                    }
                }
            }
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = new String(fileName.getBytes(), "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

