/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.unicom.utils.CONST;
import com.tydic.nicc.unicom.utils.CommonTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class HttpRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestUtils.class);

    private static RequestConfig getConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
        return requestConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        try {
            URL u = new URL(url);
            URI uri = new URI(u.getProtocol(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getRef());
            url = uri.toString();
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Content-type", "application/json");
            httpGet.setHeader("DataEncoding", "UTF-8");
            httpGet.setHeader("Accept", "*/*");
            httpGet.setConfig(HttpRequestUtils.getConfig());
            log.info(">>>>send get request,url:{}", (Object)url);
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            log.info(">>>>recv get response,url:{},result:{}", (Object)url, (Object)result);
            String string = result;
            return string;
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            log.error(">>>>send get request,url:{},timeout,{}", (Object)url, (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doGet(String url, Map<String, String> headerMap) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("DataEncoding", "UTF-8");
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpGet.setHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            JSONObject jSONObject = JSON.parseObject((String)result);
            return jSONObject;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doPost(String url, Map<String, String> headerMap, String jsonStr) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("DataEncoding", "UTF-8");
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpPost.setHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse httpResponse = null;
        try {
            if (!CommonTool.strIsEmpty(jsonStr)) {
                httpPost.setEntity((HttpEntity)new StringEntity(jsonStr, "UTF-8"));
            }
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            JSONObject jSONObject = JSON.parseObject((String)result);
            return jSONObject;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject postForForm(String url, Map<String, String> headerMap, Map<String, String> parms) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("DataEncoding", "UTF-8");
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpPost.setHeader(entry.getKey(), entry.getValue());
        }
        ArrayList list = new ArrayList();
        parms.forEach((key, value) -> list.add(new BasicNameValuePair(key, value)));
        try {
            JSONObject jsonObject;
            if (Objects.nonNull(parms) && parms.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            }
            InputStream content = httpPost.getEntity().getContent();
            InputStreamReader inputStreamReader = new InputStreamReader(content, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String readLine = bufferedReader.readLine();
            System.out.println("readLine===================================" + readLine);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            JSONObject jSONObject = jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
            return jSONObject;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (Objects.nonNull(httpClient)) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doPut(String url, String token, String jsonStr) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPut.setConfig(requestConfig);
        httpPut.setHeader("Content-type", "application/json");
        httpPut.setHeader("DataEncoding", "UTF-8");
        httpPut.setHeader("Authorization", token);
        CloseableHttpResponse httpResponse = null;
        try {
            httpPut.setEntity((HttpEntity)new StringEntity(jsonStr));
            httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            JSONObject jSONObject = JSON.parseObject((String)result);
            return jSONObject;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doDelete(String url, String token, String jsonStr) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpDelete.setConfig(requestConfig);
        httpDelete.setHeader("Content-type", "application/json");
        httpDelete.setHeader("DataEncoding", "UTF-8");
        httpDelete.setHeader("Authorization", token);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            JSONObject jSONObject = JSON.parseObject((String)result);
            return jSONObject;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static final String getIpAddress(HttpServletRequest request) throws IOException {
        String ip;
        block8: {
            block9: {
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block9;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) || !(ip = request.getRemoteAddr()).equals("127.0.0.1") && !ip.equals("0:0:0:0:0:0:0:1")) break block8;
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                block0: while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                        ip = inetAddress.getHostAddress().toString();
                        continue block0;
                    }
                }
                break block8;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public static Object webPostBody(Integer schemeInt, String host, String port, String path, String paramStr) {
        String scheme = schemeInt == CONST.HTTPS_INT ? "https" : "http";
        Mono mono = ((WebClient.RequestBodySpec)WebClient.create().post().uri(uriBuilder -> uriBuilder.scheme(scheme).host(host).port(port).path(path).build(new Object[0]))).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)paramStr)).retrieve().bodyToMono(Object.class);
        return mono.block();
    }

    public static Object webGet(Integer schemeInt, String host, String port, String path, MultiValueMap<String, String> paramMap) {
        String scheme = schemeInt == CONST.HTTPS_INT ? "https" : "http";
        Mono mono = WebClient.create().get().uri(uriBuilder -> uriBuilder.scheme(scheme).host(host).port(port).path(path).queryParams(paramMap).build(new Object[0])).retrieve().bodyToMono(Object.class);
        return mono.block();
    }

    public static Response doSendPost(String url, JSONObject taskObject) throws Exception {
        String bodyContent = taskObject.toJSONString();
        RequestBody reqBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (String)bodyContent);
        Request request = new Request.Builder().url(url).header("Content-Type", "application/json").post(reqBody).build();
        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();
        return response;
    }

    public static Object webPostFormData(Integer schemeInt, String host, String port, String path, MultiValueMap<String, String> paramMap) {
        String scheme = schemeInt == CONST.HTTPS_INT ? "https" : "http";
        Mono mono = ((WebClient.RequestBodySpec)WebClient.create().post().uri(uriBuilder -> uriBuilder.scheme(scheme).host(host).port(port).path(path).build(new Object[0]))).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData(paramMap)).retrieve().bodyToMono(Object.class);
        return mono.block();
    }

    public static String getParams(HashMap<String, Object> params) throws IOException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(params);
        Set entrys = sortedParams.entrySet();
        StringBuilder baseString = new StringBuilder();
        for (Map.Entry param : entrys) {
            if (param.getValue() == null || "".equals(((String)param.getKey()).trim()) || "".equals(((String)param.getKey()).trim()) || "".equals(param.getValue().toString().trim())) continue;
            baseString.append(((String)param.getKey()).trim()).append("=").append(URLEncoder.encode(param.getValue().toString().trim(), "UTF-8")).append("&");
        }
        return baseString.deleteCharAt(baseString.length() - 1).toString();
    }
}

