/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MD5Util {
    private static final Logger log = LogManager.getLogger(MD5Util.class);

    public static boolean verifySign(String requestToken, TreeMap<String, String> params) {
        return MD5Util.sign(params).equals(requestToken);
    }

    public static boolean verifySign(String requestToken, List<String> params) {
        return MD5Util.sign(params).equals(requestToken);
    }

    public static String sign(TreeMap<String, String> params) {
        StringBuilder paramValues = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            paramValues.append(entry.getKey());
            paramValues.append(entry.getValue());
        }
        log.debug("\u5f85\u52a0\u5bc6\u5b57\u7b26\u4e32\uff1a" + paramValues.toString());
        return MD5Util.md5(paramValues.toString());
    }

    public static String sign(List<String> params) {
        StringBuilder paramValues = new StringBuilder();
        for (String param : params) {
            paramValues.append(param);
        }
        log.debug("\u5f85\u52a0\u5bc6\u5b57\u7b26\u4e32\uff1a" + paramValues.toString());
        return MD5Util.md5(paramValues.toString());
    }

    private static String md5(String originalString) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(originalString.getBytes("UTF-8"));
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            log.info("token\uff1a" + hex.toString());
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        Long timestamp = System.currentTimeMillis();
        System.out.println(timestamp);
        System.out.println(MD5Util.md5("testapp" + timestamp + "testapp"));
    }
}

